xquery version "1.0-ml";

module namespace endpoints="http://example.com/endpoints";

declare namespace rest="http://marklogic.com/appservices/rest";

declare default function namespace "http://www.w3.org/2005/xpath-functions";

declare option xdmp:mapping "false";

declare variable $endpoints:ENDPOINTS as element(rest:options)
  := <options xmlns="http://marklogic.com/appservices/rest">

       <request uri="^/$" endpoint="/default.xqy"/>

       <request uri="^/slides/(.+?)/(\d+)$" endpoint="/slides.xqy">
         <uri-param name="deck">/slides/$1.xml</uri-param>
         <uri-param name="slide" as="decimal">$2</uri-param>
       </request>

       <request uri="^/slides/(.+?)/$" endpoint="/slides.xqy">
         <uri-param name="deck">/$1/slides.xml</uri-param>
       </request>

       <request uri="^/slides/(.+?)/$" endpoint="/slides.xqy">
         <uri-param name="deck">/$1/slides.xml</uri-param>
         <http method="POST">
           <auth>
             <privilege>http://marklogic.com/xdmp/privileges/infostudio</privilege>
           </auth>
         </http>
       </request>

       <request uri="^(.*\.xqy)(\?.*)$" endpoint="$1" user-params="allow">
         <auth>
           <privilege>http://marklogic.com/xdmp/privileges/infostudio</privilege>
         </auth>
       </request>
     </options>;

declare function endpoints:options()
as element(rest:options)
{
  $ENDPOINTS
};

declare function endpoints:request(
  $module as xs:string)
as element(rest:request)?
{
  ($ENDPOINTS/rest:request[@endpoint = $module])[1]
};
