xquery version "1.0-ml";

import module namespace rest="http://marklogic.com/appservices/rest"
       at "rest.xqy";

import module namespace endpoints="http://example.com/endpoints"
       at "endpoints.xqy";

declare default function namespace "http://www.w3.org/2005/xpath-functions";

declare namespace html="http://www.w3.org/1999/xhtml";

declare option xdmp:mapping "false";

(: should really, you know, do something useful. :)
declare function local:slide(
  $deck as xs:string,
  $slide as xs:decimal?)
as element(html:html)
{
  let $doc := doc($deck)
  return
    <html xmlns="http://www.w3.org/1999/xhtml">
      <head>
        <title>Fake easy slides</title>
      </head>
      <body>
        { if (empty($slide))
          then
            <p>This is the titlepage for "{$deck}".</p>
          else
            <p>This is slide {$slide} in "{$deck}".</p>
        }
      </body>
    </html>
};

let $params := rest:process-request(endpoints:request("/slides.xqy"))
let $deck   := map:get($params, "deck")
let $slide  := map:get($params, "slide")
return
  local:slide($deck, $slide)
