xquery version "1.0-ml";

declare default function namespace "http://www.w3.org/2005/xpath-functions";

declare option xdmp:mapping "false";

let $uri := xdmp:get-request-url()
return
  if ($uri = "/")
  then
    "/default.xqy"
  else
    if (matches($uri, "^/slides/(.+)/(\d+)$"))
    then
      replace($uri, "^/slides/(.+)/(\d+)$", "/slides.xqy?deck=$1&amp;slide=$2")
    else
      if (matches($uri, "^/slides/(.+)/?$"))
      then
        if (xdmp:get-request-method() = "POST"
            and xdmp:has-privilege("http://marklogic.com/xdmp/privileges/infostudio", "execute"))
        then
          "/post.xqy"
        else
          replace($uri, "^/slides/(.+)/?$", "/slides.xqy?deck=$1")
      else
        if ((matches($uri, "^.*\.xqy$") or matches($uri, "^.*\.xqy\?.*$"))
            and xdmp:has-privilege("http://marklogic.com/xdmp/privileges/infostudio", "execute"))
        then
          $uri
        else
          (xdmp:set-response-code(404, "Not found"),
           "/no/such/resource")
