xquery version "1.0-ml";

declare default function namespace "http://www.w3.org/2005/xpath-functions";

declare namespace html="http://www.w3.org/1999/xhtml";

declare option xdmp:mapping "false";

(: should really, you know, do something useful. :)
declare function local:slide(
  $deck as xs:string,
  $slide as xs:decimal?)
as element(html:html)
{
  let $doc := doc($deck)
  return
    <html xmlns="http://www.w3.org/1999/xhtml">
      <head>
        <title>Fake hard slides</title>
      </head>
      <body>
        { if (empty($slide))
          then
            <p>This is the titlepage for "{$deck}".</p>
          else
            <p>This is slide {$slide} in "{$deck}".</p>
        }
      </body>
    </html>
};

let $deck       := concat("/slides/", xdmp:get-request-field("deck"), ".xml")

(: let $slide := xdmp:get-request-field("slide")
   raises a coercion error later :)

let $slideparam := xdmp:get-request-field("slide")
let $slide      := if (empty($slideparam)) then () else xs:decimal($slideparam)
return
  if (true()) (: should really test if the deck exists :)
  then
    local:slide($deck, $slide)
  else
    error(xs:QName("ERROR"), concat("No slide deck named ", $deck))
