/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class SslByteChannel
implements ByteChannel {
    private final ByteChannel wrappedChannel;
    private final SSLEngine engine;
    protected final Logger logger;
    private ByteBuffer inAppData;
    private final ByteBuffer outAppData;
    private ByteBuffer inNetData;
    private final ByteBuffer outNetData;
    private boolean closed = false;
    private int timeoutMillis = 0;
    private Selector selector = null;

    public void setTimeout(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public int getTimeout() {
        return this.timeoutMillis;
    }

    public SslByteChannel(ByteChannel wrappedChannel, SSLEngine engine, Logger logger) {
        this.wrappedChannel = wrappedChannel;
        this.engine = engine;
        this.logger = logger;
        SSLSession session = engine.getSession();
        this.inAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
        this.outAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
        logger.fine("app buffer size=" + session.getApplicationBufferSize());
        this.inNetData = ByteBuffer.allocate(session.getPacketBufferSize());
        this.outNetData = ByteBuffer.allocate(session.getPacketBufferSize());
        logger.fine("app buffer size=" + session.getPacketBufferSize());
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean closeSocket) throws IOException {
        if (!this.closed) {
            this.logger.fine("closing SslByteChannel");
            try {
                try {
                    this.engine.closeOutbound();
                    SSLEngineResult ser = this.wrapAppData();
                    if (ser.getStatus() != SSLEngineResult.Status.CLOSED) {
                        this.logger.fine("SSLEngine not closed, calling handshake");
                        this.handleHandshake(ser);
                    }
                    if (closeSocket && this.selector != null) {
                        this.selector.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (closeSocket) {
                    this.wrappedChannel.close();
                }
            }
            finally {
                this.closed = true;
            }
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public int read(ByteBuffer clientBuffer) throws IOException {
        int bytesCopied = this.copyOutClientData(clientBuffer);
        if (bytesCopied > 0) {
            return bytesCopied;
        }
        this.fillBufferFromEngine();
        bytesCopied = this.copyOutClientData(clientBuffer);
        if (bytesCopied > 0) {
            return bytesCopied;
        }
        return -1;
    }

    private void fillBufferFromEngine() throws IOException {
        SSLEngineResult ser;
        block9: while ((ser = this.unwrapNetData()).bytesProduced() <= 0) {
            switch (ser.getStatus()) {
                case OK: {
                    break;
                }
                case CLOSED: {
                    this.close();
                    return;
                }
                case BUFFER_OVERFLOW: {
                    int appSize = this.engine.getSession().getApplicationBufferSize();
                    ByteBuffer b = ByteBuffer.allocate(appSize + this.inAppData.position());
                    this.inAppData.flip();
                    b.put(this.inAppData);
                    this.inAppData = b;
                    continue block9;
                }
                case BUFFER_UNDERFLOW: {
                    int rc;
                    ByteBuffer b;
                    int netSize = this.engine.getSession().getPacketBufferSize();
                    if (netSize > this.inNetData.capacity()) {
                        b = ByteBuffer.allocate(netSize);
                        this.inNetData.flip();
                        b.put(this.inNetData);
                        this.inNetData = b;
                    }
                    if ((rc = this.timedRead(this.inNetData, this.timeoutMillis)) == 0 && this.timeoutMillis > 0) {
                        throw new IOException("Timeout waiting for read (" + this.timeoutMillis + " milliseconds)");
                    }
                    if (rc != -1) continue block9;
                    break;
                }
            }
            switch (ser.getHandshakeStatus()) {
                case NOT_HANDSHAKING: {
                    return;
                }
            }
            this.handleHandshake(ser);
        }
        return;
    }

    public int readInsideHandshake(ByteBuffer clientBuffer) throws IOException {
        int bytesCopied = this.copyOutClientData(clientBuffer);
        if (bytesCopied > 0) {
            this.logger.fine("read bytesCopied=" + bytesCopied);
            return bytesCopied;
        }
        int handShake = this.fillBufferFromEngineInsideHandshake();
        if (handShake == -2) {
            return handShake;
        }
        bytesCopied = this.copyOutClientData(clientBuffer);
        if (bytesCopied > 0) {
            this.logger.fine("read bytesCopied=" + bytesCopied);
            return bytesCopied;
        }
        return -1;
    }

    private int fillBufferFromEngineInsideHandshake() throws IOException {
        boolean doneHandshake = false;
        SSLEngineResult ser;
        block9: while ((ser = this.unwrapNetData()).bytesProduced() <= 0) {
            switch (ser.getStatus()) {
                case OK: {
                    break;
                }
                case CLOSED: {
                    this.close();
                    return 0;
                }
                case BUFFER_OVERFLOW: {
                    int appSize = this.engine.getSession().getApplicationBufferSize();
                    ByteBuffer b = ByteBuffer.allocate(appSize + this.inAppData.position());
                    this.inAppData.flip();
                    b.put(this.inAppData);
                    this.inAppData = b;
                    continue block9;
                }
                case BUFFER_UNDERFLOW: {
                    int rc;
                    ByteBuffer b;
                    if (doneHandshake) {
                        return -2;
                    }
                    int netSize = this.engine.getSession().getPacketBufferSize();
                    if (netSize > this.inNetData.capacity()) {
                        b = ByteBuffer.allocate(netSize);
                        this.inNetData.flip();
                        b.put(this.inNetData);
                        this.inNetData = b;
                    }
                    if ((rc = this.timedRead(this.inNetData, this.timeoutMillis)) == 0 && this.timeoutMillis > 0) {
                        throw new IOException("Timeout waiting for read (" + this.timeoutMillis + " milliseconds)");
                    }
                    if (rc != -1) continue block9;
                    break;
                }
            }
            switch (ser.getHandshakeStatus()) {
                case NOT_HANDSHAKING: {
                    return 0;
                }
            }
            this.handleHandshake(ser);
            doneHandshake = true;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int timedRead(ByteBuffer buf, int timeoutMillis) throws IOException {
        SelectableChannel ch;
        if (timeoutMillis <= 0) {
            return this.wrappedChannel.read(buf);
        }
        SelectableChannel selectableChannel = ch = (SelectableChannel)((Object)this.wrappedChannel);
        synchronized (selectableChannel) {
            int n;
            block9: {
                SelectionKey key = null;
                if (this.selector == null) {
                    this.selector = Selector.open();
                }
                try {
                    this.selector.selectNow();
                    ch.configureBlocking(false);
                    key = ch.register(this.selector, 1);
                    this.selector.select(timeoutMillis);
                    n = this.wrappedChannel.read(buf);
                    if (key == null) break block9;
                    key.cancel();
                }
                catch (Throwable throwable) {
                    if (key != null) {
                        key.cancel();
                    }
                    ch.configureBlocking(true);
                    throw throwable;
                }
            }
            ch.configureBlocking(true);
            return n;
        }
    }

    @Override
    public int write(ByteBuffer clientBuffer) throws IOException {
        int bytesWritten = 0;
        while (clientBuffer.remaining() > 0) {
            bytesWritten += this.pushToEngine(clientBuffer);
        }
        return bytesWritten;
    }

    private int pushToEngine(ByteBuffer clientBuffer) throws IOException {
        int bytesWritten = 0;
        while (clientBuffer.remaining() > 0) {
            this.logger.fine("bytesWritten=" + (bytesWritten += this.copyInClientData(clientBuffer)));
            block10: while (this.outAppData.position() > 0) {
                SSLEngineResult ser = this.wrapAppData();
                this.logger.fine("ser.getStatus()=" + (Object)((Object)ser.getStatus()));
                this.logger.fine("ser.getHandshakeStatus()=" + (Object)((Object)ser.getHandshakeStatus()));
                this.logger.fine("app bytes after wrap()=" + this.outAppData.position());
                switch (ser.getStatus()) {
                    case OK: {
                        break;
                    }
                    case CLOSED: {
                        this.pushNetData();
                        this.close();
                        return bytesWritten;
                    }
                    case BUFFER_OVERFLOW: {
                        continue block10;
                    }
                    case BUFFER_UNDERFLOW: {
                        return bytesWritten;
                    }
                }
                switch (ser.getHandshakeStatus()) {
                    case NOT_HANDSHAKING: {
                        continue block10;
                    }
                }
                this.handleHandshake(ser);
            }
        }
        return bytesWritten;
    }

    private void handleHandshake(SSLEngineResult initialSer) throws IOException {
        SSLEngineResult ser = initialSer;
        while (ser.getStatus() != SSLEngineResult.Status.CLOSED) {
            if (ser.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                int n = this.readInsideHandshake(this.inNetData);
                if (n == -2) {
                    return;
                }
                if (n < 0) {
                    throw new EOFException("SSL wrapped byte channel");
                }
            }
            switch (ser.getHandshakeStatus()) {
                case NEED_TASK: {
                    Runnable task;
                    while ((task = this.engine.getDelegatedTask()) != null) {
                        task.run();
                    }
                    this.pushNetData();
                    ser = this.wrapAppData();
                    break;
                }
                case NEED_WRAP: {
                    this.pushNetData();
                    ser = this.wrapAppData();
                    break;
                }
                case NEED_UNWRAP: {
                    int n;
                    this.pushNetData();
                    if (this.inNetData.position() == 0 && (n = this.wrappedChannel.read(this.inNetData)) < 0) {
                        throw new EOFException("SSL wrapped byte channel");
                    }
                    ser = this.unwrapNetData();
                    break;
                }
                case NOT_HANDSHAKING: 
                case FINISHED: {
                    return;
                }
            }
        }
    }

    private SSLEngineResult unwrapNetData() throws SSLException {
        this.inNetData.flip();
        SSLEngineResult ser = this.engine.unwrap(this.inNetData, this.inAppData);
        this.inNetData.compact();
        return ser;
    }

    private SSLEngineResult wrapAppData() throws IOException {
        this.outAppData.flip();
        SSLEngineResult ser = this.engine.wrap(this.outAppData, this.outNetData);
        this.outAppData.compact();
        this.pushNetData();
        return ser;
    }

    private void pushNetData() throws IOException {
        this.outNetData.flip();
        while (this.outNetData.remaining() > 0) {
            this.wrappedChannel.write(this.outNetData);
        }
        this.outNetData.compact();
    }

    private int copyInClientData(ByteBuffer clientBuffer) {
        if (clientBuffer.remaining() == 0) {
            return 0;
        }
        int posBefore = clientBuffer.position();
        if (clientBuffer.remaining() <= this.outAppData.remaining()) {
            this.outAppData.put(clientBuffer);
        } else {
            while (clientBuffer.hasRemaining() && this.outAppData.hasRemaining()) {
                this.outAppData.put(clientBuffer.get());
            }
        }
        return clientBuffer.position() - posBefore;
    }

    private int copyOutClientData(ByteBuffer clientBuffer) {
        this.inAppData.flip();
        int posBefore = this.inAppData.position();
        if (this.inAppData.remaining() <= clientBuffer.remaining()) {
            clientBuffer.put(this.inAppData);
        } else {
            while (clientBuffer.hasRemaining()) {
                clientBuffer.put(this.inAppData.get());
            }
        }
        int posAfter = this.inAppData.position();
        this.inAppData.compact();
        return posAfter - posBefore;
    }
}

