/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.http.MultipartBuffer;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultChannelName;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.StreamingResultException;
import com.marklogic.xcc.impl.AbstractResultSequence;
import com.marklogic.xcc.impl.CachedResultSequence;
import com.marklogic.xcc.impl.EmptyResultSequence;
import com.marklogic.xcc.impl.SessionImpl;
import com.marklogic.xcc.spi.ServerConnection;
import com.marklogic.xcc.types.ValueType;
import com.marklogic.xcc.types.XdmItem;
import com.marklogic.xcc.types.impl.SequenceImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamingResultSequence
extends AbstractResultSequence {
    private final SessionImpl session;
    private final MultipartBuffer mbuf;
    private final RequestOptions options;
    private final Logger logger;
    private final long startTime;
    private ServerConnection connection;
    private boolean closed = false;
    private int cursor = -1;
    private ResultItem currentItem = null;
    private IteratorAdapter currentIterator = null;

    public StreamingResultSequence(Request request, ServerConnection connection, MultipartBuffer mbuf, RequestOptions options, Logger logger) {
        super(request);
        this.session = (SessionImpl)request.getSession();
        this.connection = connection;
        this.mbuf = mbuf;
        this.options = options;
        this.logger = logger;
        this.startTime = System.currentTimeMillis();
        this.session.registerResultSequence(this);
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public long getTotalBytesRead() {
        return this.mbuf.getTotalBytesRead();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.invalidateCurrentIterator();
        this.session.deRegisterResultSequence(this);
        long now = System.currentTimeMillis();
        try {
            this.mbuf.close();
        }
        catch (IOException e) {
            String msg = "IOException closing streaming ResultSequence: " + e.getMessage();
            this.logger.log(Level.WARNING, msg, e);
            throw new StreamingResultException(msg, this, e);
        }
        finally {
            this.connection.provider().returnConnection(this.connection, this.logger);
            this.connection = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private boolean hasNext(IteratorAdapter it) {
        if (this.closed) {
            return false;
        }
        if (it != this.currentIterator) {
            this.invalidateCurrentIterator();
        }
        try {
            return this.sequencePart != null || this.mbuf.hasNext();
        }
        catch (IOException e) {
            String msg = "IOException in streaming ResultSequence hasNext(): " + e.getMessage();
            this.logger.log(Level.SEVERE, msg, e);
            throw new StreamingResultException(msg, this, e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext(null);
    }

    private ResultItem next(IteratorAdapter it) {
        this.assertNotClosed();
        if (it != this.currentIterator) {
            this.invalidateCurrentIterator();
        }
        ++this.cursor;
        try {
            if (this.sequencePart != null || this.mbuf.hasNext()) {
                this.currentItem = this.instantiateResultItem(this.mbuf, this.cursor, this.options);
            } else {
                this.currentItem = null;
                this.cursor = -1;
            }
        }
        catch (RequestException e) {
            String msg = "RequestException instantiating ResultItem " + this.cursor + ": " + e.getMessage();
            this.logger.log(Level.SEVERE, msg, e);
            throw new StreamingResultException(msg, this, e);
        }
        catch (IOException e) {
            String msg = "IOException instantiating ResultItem " + this.cursor + ": " + e.getMessage();
            this.logger.log(Level.SEVERE, msg, e);
            throw new StreamingResultException(msg, this, e);
        }
        return this.currentItem;
    }

    @Override
    public ResultItem next() {
        return this.next(null);
    }

    @Override
    public ResultItem current() {
        this.assertNotClosed();
        if (this.currentItem == null) {
            throw new IllegalStateException("No current item");
        }
        return this.currentItem;
    }

    @Override
    public ResultItem resultItemAt(int index) {
        this.assertNotClosed();
        if (this.cursor == -1 || index != this.cursor) {
            throw new IllegalArgumentException("Index out of range or not current, index=" + index);
        }
        return this.currentItem;
    }

    @Override
    public void rewind() {
        this.assertNotClosed();
        throw new IllegalStateException("Cannot rewind streaming result sequences");
    }

    @Override
    public ResultSequence toCached() {
        this.assertNotClosed();
        if (this.currentItem != null && !this.currentItem.isFetchable()) {
            this.next();
        }
        try {
            CachedResultSequence rs = new CachedResultSequence(this.request, this.mbuf, this.options);
            this.close();
            return rs;
        }
        catch (RequestException e) {
            String msg = "RequestException while caching streaming ResultSequence: " + e.getMessage();
            this.logger.log(Level.SEVERE, msg, e);
            throw new StreamingResultException(msg, this, e);
        }
        catch (IOException e) {
            String msg = "IOException while caching streaming ResultSequence: " + e.getMessage();
            this.logger.log(Level.SEVERE, msg, e);
            throw new StreamingResultException(msg + e.getMessage(), this, e);
        }
    }

    @Override
    public ResultItem[] toResultItemArray() {
        ArrayList<ResultItem> list = new ArrayList<ResultItem>();
        while (this.hasNext()) {
            ResultItem item = this.next();
            item.cache();
            list.add(item);
        }
        ResultItem[] array = new ResultItem[list.size()];
        list.toArray(array);
        this.close();
        return array;
    }

    @Override
    public ResultSequence getChannel(ResultChannelName channel) {
        this.assertNotClosed();
        if (channel == ResultChannelName.PRIMARY) {
            return this;
        }
        return new EmptyResultSequence(this);
    }

    @Override
    public Iterator<ResultItem> iterator() {
        this.assertNotClosed();
        this.invalidateCurrentIterator();
        this.currentIterator = new IteratorAdapter(this);
        return this.currentIterator;
    }

    @Override
    public XdmItem itemAt(int index) {
        return this.resultItemAt(index).getItem();
    }

    @Override
    public boolean isEmpty() {
        return this.closed;
    }

    @Override
    public XdmItem[] toArray() {
        ResultItem[] resultItems = this.toResultItemArray();
        XdmItem[] array = new XdmItem[resultItems.length];
        for (int i = 0; i < resultItems.length; ++i) {
            array[i] = resultItems[i].getItem();
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String asString(String separator) {
        try (ResultSequence cachedSequence = null;){
            cachedSequence = this.toCached();
            String string = cachedSequence.asString(separator);
            return string;
        }
    }

    @Override
    public String asString() {
        return this.asString("\n");
    }

    @Override
    public String[] asStrings() {
        return SequenceImpl.asStringArray(this);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.SEQUENCE;
    }

    @Override
    public String toString() {
        return "StreamingResultSequence: closed=" + this.closed;
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("ResultSequence is closed");
        }
    }

    private void invalidateCurrentIterator() {
        if (this.currentIterator != null) {
            this.currentIterator.invalidate();
        }
    }

    private static class IteratorAdapter
    implements Iterator<ResultItem> {
        private StreamingResultSequence parent;
        private volatile boolean invalidated = false;

        public IteratorAdapter(StreamingResultSequence parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasNext() {
            this.assertValid();
            return this.parent.hasNext(this);
        }

        @Override
        public ResultItem next() {
            this.assertValid();
            ResultItem obj = this.parent.next(this);
            if (obj == null) {
                throw new NoSuchElementException("No more items in ResultSequence");
            }
            return obj;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ResultSequences are not mutable");
        }

        private void invalidate() {
            this.invalidated = true;
        }

        private void assertValid() {
            if (this.invalidated) {
                throw new ConcurrentModificationException("This Iterator has been invalidated");
            }
        }
    }
}

