/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.types;

import com.marklogic.xcc.types.XdmDuration;
import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration
implements XdmDuration {
    private static final BigDecimal ZERO = new BigDecimal("0.0");
    private boolean negative = false;
    private int years = 0;
    private int months = 0;
    private int days = 0;
    private int hours = 0;
    private int minutes = 0;
    private BigDecimal seconds = ZERO;
    private static final String DURATION_PATTERN = "(-)?P((\\d+)Y)?((\\d+)M)?((\\d+)D)?(T((\\d+)H)?((\\d+)M)?((\\d*\\.?\\d*)S)?)?";
    private static final int SIGN = 1;
    private static final int YEARS = 3;
    private static final int MONTHS = 5;
    private static final int DAYS = 7;
    private static final int HOURS = 10;
    private static final int MINUTES = 12;
    private static final int SECONDS = 14;
    private static final Pattern durPattern = Pattern.compile("(-)?P((\\d+)Y)?((\\d+)M)?((\\d+)D)?(T((\\d+)H)?((\\d+)M)?((\\d*\\.?\\d*)S)?)?");

    public Duration() {
    }

    public Duration(String duration) {
        this.parseDuration(duration);
    }

    public Duration(boolean negative, int years, int months, int days, int hours, int minutes, BigDecimal seconds) {
        this.negative = negative;
        this.years = years;
        this.months = months;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds == null ? ZERO : seconds;
    }

    @Override
    public boolean isPositive() {
        return !this.negative;
    }

    @Override
    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public int getYears() {
        return this.years;
    }

    @Override
    public int getMonths() {
        return this.months;
    }

    @Override
    public int getDays() {
        return this.days;
    }

    @Override
    public int getHours() {
        return this.hours;
    }

    @Override
    public int getMinutes() {
        return this.minutes;
    }

    @Override
    public long getWholeSeconds() {
        return this.seconds.intValue();
    }

    @Override
    public BigDecimal getSeconds() {
        return this.seconds;
    }

    public void setSign(boolean negative) {
        this.negative = negative;
    }

    public void setYears(int years) {
        this.years = years;
    }

    public void setMonths(int months) {
        this.months = months;
    }

    public void setDays(int days) {
        this.days = days;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public void setWholeSeconds(long seconds) {
        this.seconds = new BigDecimal("" + seconds);
    }

    private void parseDuration(String dur) {
        Matcher matcher = durPattern.matcher(dur);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Not a valid duration: " + dur);
        }
        this.negative = "-".equals(matcher.group(1));
        this.years = this.intValue(matcher.group(3));
        this.months = this.intValue(matcher.group(5));
        this.days = this.intValue(matcher.group(7));
        this.hours = this.intValue(matcher.group(10));
        this.minutes = this.intValue(matcher.group(12));
        this.seconds = this.bigDecimalValue(matcher.group(14));
    }

    private int intValue(String strValue) {
        if (strValue == null || strValue.length() == 0) {
            return 0;
        }
        return Integer.parseInt(strValue);
    }

    private BigDecimal bigDecimalValue(String strValue) {
        if (strValue == null || strValue.length() == 0) {
            return ZERO;
        }
        return new BigDecimal(strValue);
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (!(otherObj instanceof XdmDuration)) {
            return false;
        }
        XdmDuration other = (XdmDuration)otherObj;
        return other.isNegative() == this.negative && other.getYears() == this.years && other.getMonths() == this.months && other.getDays() == this.days && other.getHours() == this.hours && other.getMinutes() == this.minutes && other.getSeconds().equals(this.seconds);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.negative) {
            sb.append("-");
        }
        sb.append("P");
        if (this.years == 0 && this.months == 0 && this.days == 0 && this.hours == 0 && this.minutes == 0 && this.seconds.equals(ZERO)) {
            sb.append("T0S");
            return sb.toString();
        }
        if (this.years != 0) {
            sb.append(String.valueOf(this.years)).append("Y");
        }
        if (this.months != 0) {
            sb.append(String.valueOf(this.months)).append("M");
        }
        if (this.days != 0) {
            sb.append(String.valueOf(this.days)).append("D");
        }
        if (this.hours != 0 || this.minutes != 0 || !this.seconds.equals(ZERO)) {
            sb.append("T");
        }
        if (this.hours != 0) {
            sb.append(String.valueOf(this.hours)).append("H");
        }
        if (this.minutes != 0) {
            sb.append(String.valueOf(this.minutes)).append("M");
        }
        if (!this.seconds.equals(ZERO)) {
            BigDecimal intVal = new BigDecimal(this.seconds.toBigInteger());
            if (this.seconds.compareTo(intVal) == 0) {
                sb.append(intVal);
            } else {
                sb.append(this.seconds);
            }
            sb.append("S");
        }
        return sb.toString();
    }
}

