/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.examples;

import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.SecurityOptions;
import com.marklogic.xcc.Session;
import java.io.FileInputStream;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class HelloSecureWorld {
    public static void main(String[] args) throws Exception {
        KeyManager[] keyManagers;
        String passphrase;
        TrustManager[] trustManagers;
        if (args.length < 2 || args.length > 4) {
            System.err.println("usage: xccs://user:password@host:port/contentbase trustJKS|DEFAULT|ANY [clientJKS [passphrase]]");
            System.err.println();
            System.err.println("trustJKS may be one of:");
            System.err.println("    path    to use Java Key Store containing trusted signing authorities.");
            System.err.println("    DEFAULT to use Java default cacerts file.");
            System.err.println("    ANY     to accept any server certificate.");
            System.err.println();
            System.err.println("clientJKS is optional path to Java Key Store containing client certificates.");
            System.err.println();
            System.err.println("passphrase is optional passphrase for client key store.");
            return;
        }
        URI uri = new URI(args[0]);
        String trustJKS = args[1];
        if (trustJKS.equals("DEFAULT")) {
            trustManagers = null;
        } else if (trustJKS.equals("ANY")) {
            trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
        } else {
            KeyStore trustedKeyStore = KeyStore.getInstance("JKS");
            trustedKeyStore.load(new FileInputStream(args[1]), null);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(trustedKeyStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        String clientJKS = args.length > 2 ? args[2] : null;
        String string = passphrase = args.length > 3 ? args[3] : "";
        if (clientJKS == null) {
            keyManagers = null;
        } else {
            KeyStore clientKeyStore = KeyStore.getInstance("JKS");
            try (FileInputStream is = new FileInputStream(clientJKS);){
                clientKeyStore.load(is, null);
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(clientKeyStore, passphrase.toCharArray());
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        SSLContext sslContext = SSLContext.getInstance("TLSv1");
        sslContext.init(keyManagers, trustManagers, null);
        SecurityOptions securityOptions = new SecurityOptions(sslContext);
        securityOptions.setEnabledProtocols(new String[]{"TLSv1"});
        securityOptions.setEnabledCipherSuites(new String[]{"TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA"});
        ContentSource contentSource = ContentSourceFactory.newContentSource((URI)uri, (SecurityOptions)securityOptions);
        Session session = contentSource.newSession();
        AdhocQuery request = session.newAdhocQuery("\"Hello World\"");
        ResultSequence rs = session.submitRequest((Request)request);
        System.out.println(rs.asString());
        session.close();
    }
}

