/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.examples;

import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.ModuleSpawn;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.XccConfigException;
import com.marklogic.xcc.types.ValueType;
import java.net.URI;

public class ModuleRunner {
    private final Session session;
    private final ModuleSpawn request;
    private RequestOptions options;

    public ModuleRunner(URI serverUri) throws XccConfigException {
        ContentSource cs = ContentSourceFactory.newContentSource((URI)serverUri);
        this.session = cs.newSession();
        this.request = this.session.newModuleSpawn(null);
    }

    public ResultSequence invoke(String moduleUri) throws RequestException {
        this.request.setModuleUri(moduleUri);
        this.request.setOptions(this.options);
        this.request.setNewVariable("my-namespace-uri", "uri", (ValueType)ValueType.XS_STRING, (Object)"28477-moduleInvoke.xml");
        this.request.setNewVariable("my-namespace-uri", "doc", (ValueType)ValueType.DOCUMENT, (Object)"<foo/>");
        return this.session.submitRequest((Request)this.request);
    }

    public String[] invokeToStringArray(String moduleUri) throws RequestException {
        ResultSequence rs = this.invoke(moduleUri);
        return rs.asStrings();
    }

    public String invokeToSingleString(String moduleUri, String separator) throws RequestException {
        ResultSequence rs = this.invoke(moduleUri);
        String str = rs.asString(separator);
        rs.close();
        return str;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequestOptions(RequestOptions options) {
        this.options = options;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            ModuleRunner.usage();
            return;
        }
        URI serverUri = new URI(args[0]);
        String moduleUri = args[1];
        ModuleRunner runner = new ModuleRunner(serverUri);
        String result = runner.invokeToSingleString(moduleUri, System.getProperty("line.separator"));
        System.out.println(result);
    }

    private static void usage() {
        System.err.println("usage: serveruri docuri [-o outfilename]");
    }
}

