/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.examples;

import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.examples.OutputStreamContent;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;

public class OutputStreamInserter {
    private OutputStreamInserter() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            OutputStreamInserter.usage();
            return;
        }
        URI serverUri = new URI(args[0]);
        String docUri = args[1];
        ContentSource cs = ContentSourceFactory.newContentSource((URI)serverUri);
        Session session = cs.newSession();
        ContentCreateOptions options = ContentCreateOptions.newXmlInstance();
        OutputStreamContent content = new OutputStreamContent(docUri, options);
        OutputStream out = content.getOutputStream();
        DocBuilder producer = new DocBuilder(out, 50);
        Thread thread = OutputStreamInserter.spawnThread(producer);
        session.insertContent((Content)content);
        session.close();
        thread.join();
    }

    public static Thread spawnThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.start();
        return thread;
    }

    private static void usage() {
        System.err.println("usage: serveruri docuri");
    }

    public static class DocBuilder
    implements Runnable {
        private final OutputStream out;
        private final int lines;

        public DocBuilder(OutputStream out, int lines) {
            this.out = out;
            this.lines = lines;
        }

        @Override
        public void run() {
            StringBuffer sb = new StringBuffer();
            try {
                this.out.write("<file>\n".getBytes());
                for (int i = 0; i < this.lines; ++i) {
                    sb.setLength(0);
                    sb.append("<line index=\"");
                    sb.append(i);
                    sb.append("\">xxxxxxxxxxxxxxxxx</line>\n");
                    this.out.write(sb.toString().getBytes());
                }
                this.out.write("</file>\n".getBytes());
                this.out.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

