/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.examples;

import com.marklogic.xcc.examples.SemiBufferedContent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;

public class TestSemiBufferedContent
extends TestCase {
    private static final String s1 = "This is a string that's longer than 10 chars";

    private InputStream createByteStream(String s) {
        return new ByteArrayInputStream(s.getBytes());
    }

    public void testFullyBuffered() throws IOException {
        SemiBufferedContent content = new SemiBufferedContent("foo", null, this.createByteStream(s1), 1000);
        String result = this.streamToString(content.openDataStream());
        content.close();
        TestSemiBufferedContent.assertEquals((String)s1, (String)result);
    }

    public void testPartiallyBuffered() throws IOException {
        SemiBufferedContent content = new SemiBufferedContent("foo", null, this.createByteStream(s1), 10);
        String result = this.streamToString(content.openDataStream());
        content.close();
        TestSemiBufferedContent.assertEquals((String)s1, (String)result);
    }

    public void testPartiallyBufferedBadTempDir() throws IOException {
        try {
            new SemiBufferedContent("foo", null, this.createByteStream(s1), 10, new File("/xxxxxfooo/xxxx"));
            TestSemiBufferedContent.fail((String)"Expected IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String streamToString(InputStream inputStream) throws IOException {
        int rc;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((rc = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, rc);
        }
        inputStream.close();
        return bos.toString();
    }
}

