/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.examples;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import java.net.URI;
import javax.transaction.xa.XAResource;

public class XA {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("usage: xcc://user1:password1@host1:port1/contentbase1 xcc://user2:password2@host2:port2/contentbase2");
            System.err.println();
            System.err.println("Specify two MarkLogic clusters to participate in the distributed transaction.");
            System.err.println("hint: You can try out XA transactions across two databases in the same MarkLogic cluster");
            System.err.println("      by specifying the same host with different contentbases in the two URLs.");
            return;
        }
        final ContentSource cs1 = ContentSourceFactory.newContentSource((URI)new URI(args[0]));
        final ContentSource cs2 = ContentSourceFactory.newContentSource((URI)new URI(args[1]));
        RecoveryManager rm = RecoveryManager.manager();
        for (RecoveryModule mod : rm.getModules()) {
            if (!(mod instanceof XARecoveryModule)) continue;
            ((XARecoveryModule)mod).addXAResourceRecoveryHelper(new XAResourceRecoveryHelper(){

                public boolean initialise(String p) throws Exception {
                    return true;
                }

                public XAResource[] getXAResources() throws Exception {
                    return new XAResource[]{cs1.newSession().getXAResource(), cs2.newSession().getXAResource()};
                }
            });
            break;
        }
        rm.scan();
        javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
        Session session1 = cs1.newSession();
        Session session2 = cs2.newSession();
        try {
            tm.begin();
            tm.getTransaction().enlistResource(session1.getXAResource());
            tm.getTransaction().enlistResource(session2.getXAResource());
            AdhocQuery req = session1.newAdhocQuery("xquery version '1.0-ml';\nxdmp:host-status(xdmp:host())//*:transaction\n  [*:transaction-id eq xdmp:transaction()],\nxdmp:document-insert('query1', <query1/>)");
            ResultSequence rs = session1.submitRequest((Request)req);
            System.out.println(rs.asString(System.getProperty("line.separator")));
            rs.close();
            req = session2.newAdhocQuery("xquery version '1.0-ml';\nxdmp:host-status(xdmp:host())//*:transaction\n  [*:transaction-id eq xdmp:transaction()],\nxdmp:document-insert('query2', <query2/>)");
            rs = session2.submitRequest((Request)req);
            System.out.println(rs.asString(System.getProperty("line.separator")));
            rs.close();
            tm.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (tm.getTransaction() != null) {
                tm.rollback();
            }
        }
        finally {
            session1.close();
            session2.close();
        }
        rm.terminate();
    }
}

