/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.examples;

import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultItem;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.XccConfigException;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;

public class ContentFetcher {
    private final Session session;
    private RequestOptions options = null;
    private static final int MILLIS = 1000;
    private static final int SECONDS = 1000;
    private static final int MINUTES = 60000;
    private static final int HOURS = 3600000;

    public ContentFetcher(URI serverUri) throws XccConfigException {
        ContentSource cs = ContentSourceFactory.newContentSource((URI)serverUri);
        this.session = cs.newSession();
        this.options = new RequestOptions();
        this.options.setCacheResult(false);
    }

    private void fetch(String docUri, OutputStream outStream) throws RequestException, IOException {
        AdhocQuery request = this.session.newAdhocQuery("doc (\"" + docUri + "\")", this.options);
        ResultSequence rs = this.session.submitRequest((Request)request);
        ResultItem item = rs.next();
        if (item == null) {
            throw new IllegalArgumentException("No document found with URI '" + docUri + "'");
        }
        item.writeTo(outStream);
    }

    public void setRequestOptions(RequestOptions options) {
        this.options = options;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] args) throws Exception {
        FilterOutputStream outStream;
        if (args.length < 2) {
            ContentFetcher.usage();
            return;
        }
        URI serverUri = new URI(args[0]);
        String docUri = args[1];
        if (args.length == 4) {
            if (!args[2].equals("-o")) {
                ContentFetcher.usage();
                return;
            }
            outStream = new BufferedOutputStream(new FileOutputStream(args[3]));
        } else {
            outStream = System.out;
        }
        ContentFetcher fetcher = new ContentFetcher(serverUri);
        long start = System.currentTimeMillis();
        fetcher.fetch(docUri, outStream);
        if (outStream != System.out) {
            ((OutputStream)outStream).close();
        }
        System.err.println("Fetched " + docUri + " in " + ContentFetcher.formatTime(System.currentTimeMillis() - start));
    }

    private static void usage() {
        System.err.println("usage: serveruri docuri [-o outfilename]");
    }

    private static String formatTime(long millis) {
        StringBuffer sb = new StringBuffer();
        long n = millis / 3600000L;
        if (n != 0L) {
            sb.append(n).append("h");
        }
        if ((n = millis % 3600000L / 60000L) != 0L) {
            sb.append(n).append("m");
        }
        sb.append(millis % 60000L / 1000L).append(".");
        n = millis % 1000L;
        if (n < 100L) {
            sb.append("0");
        }
        if (n < 10L) {
            sb.append("0");
        }
        sb.append(n).append("s");
        return sb.toString();
    }
}

