/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.examples;

import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.examples.QueryHelper;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.XccConfigException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class ContentLoader {
    private final Session session;
    private ContentCreateOptions options = null;

    public ContentLoader(URI serverUri) throws XccConfigException {
        ContentSource cs = ContentSourceFactory.newContentSource((URI)serverUri);
        this.session = cs.newSession();
    }

    public void load(String[] uris, File[] files) throws RequestException {
        Content[] contents = new Content[files.length];
        for (int i = 0; i < files.length; ++i) {
            contents[i] = ContentFactory.newContent((String)uris[i], (File)files[i], (ContentCreateOptions)this.options);
        }
        this.session.insertContent(contents);
    }

    public void load(File[] files) throws RequestException {
        String[] uris = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            uris[i] = files[i].getAbsolutePath();
        }
        this.load(uris, files);
    }

    public void setOptions(ContentCreateOptions options) {
        this.options = options;
    }

    public static void main(String[] args) throws URISyntaxException, XccConfigException, RequestException {
        if (args.length < 2) {
            ContentLoader.usage();
            return;
        }
        URI serverUri = new URI(args[0]);
        File[] files = new File[args.length - 1];
        long totalByteCount = 0L;
        for (int i = 0; i < files.length; ++i) {
            files[i] = new File(args[i + 1]);
            totalByteCount += files[i].length();
        }
        ContentLoader loader = new ContentLoader(serverUri);
        long start = System.currentTimeMillis();
        loader.load(files);
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("Loaded " + files.length + " files (" + QueryHelper.formatInteger(totalByteCount) + " bytes) in " + QueryHelper.formatTime(elapsed) + " (" + QueryHelper.formatInteger(QueryHelper.bytesPerSecond(totalByteCount, elapsed)) + " bytes/second)");
    }

    private static void usage() {
        System.err.println("usage: serveruri docpath ...");
    }
}

