/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.examples;

import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.Session;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public class DynamicContentStream
extends InputStream {
    private int position = -1;
    private int limit = -1;
    private byte[] buffer = new byte[1024];
    private final int NEW = 0;
    private final int RUNNING = 1;
    private final int FINISHING = 2;
    private final int DONE = 3;
    private final int lines;
    private int state = 0;
    private int currentLine = 0;

    @Override
    public int read() throws IOException {
        byte[] temp = new byte[1];
        int rc = this.read(temp, 0, 1);
        return rc == -1 ? -1 : temp[0];
    }

    @Override
    public int read(byte[] userBuffer, int off, int len) throws IOException {
        if (this.position == this.limit) {
            this.limit = this.fillBuffer(this.buffer);
            if (this.limit == -1) {
                return -1;
            }
            this.position = 0;
        }
        int copyLen = Math.min(this.limit - this.position, len);
        System.arraycopy(this.buffer, this.position, userBuffer, off, copyLen);
        this.position += copyLen;
        return copyLen;
    }

    public DynamicContentStream(int lines) {
        this.lines = lines;
    }

    public int fillBuffer(byte[] buffer) {
        if (this.state == 3) {
            return -1;
        }
        if (this.state == 0) {
            this.state = 1;
            return this.copyStringBytes("<file>\n", buffer, 0);
        }
        if (this.state == 2) {
            this.state = 3;
            return this.copyStringBytes("</file>\n", buffer, 0);
        }
        int count = 0;
        count += this.copyStringBytes("\t<line index=\"" + this.currentLine + "\">", buffer, count);
        for (int i = 0; i < 26; ++i) {
            buffer[count] = (byte)(97 + (i + this.currentLine) % 26);
            ++count;
        }
        count += this.copyStringBytes("</line>\n", buffer, count);
        ++this.currentLine;
        if (this.currentLine == this.lines) {
            this.state = 2;
        }
        return count;
    }

    private int copyStringBytes(String str, byte[] buffer, int offset) {
        byte[] bytes = str.getBytes();
        System.arraycopy(bytes, 0, buffer, offset, bytes.length);
        return bytes.length;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            DynamicContentStream.usage();
            return;
        }
        URI serverUri = new URI(args[0]);
        String docUri = args[1];
        ContentSource cs = ContentSourceFactory.newContentSource((URI)serverUri);
        Session session = cs.newSession();
        ContentCreateOptions options = ContentCreateOptions.newXmlInstance();
        DynamicContentStream inputStream = new DynamicContentStream(30);
        Content content = ContentFactory.newUnBufferedContent((String)docUri, (InputStream)inputStream, (ContentCreateOptions)options);
        session.insertContent(content);
        session.close();
    }

    private static void usage() {
        System.err.println("usage: serveruri docuri");
    }
}

