/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.examples;

import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class OutputStreamContent
implements Content {
    private final OutputStream sink;
    private final InputStream source;
    private final Content content;

    public OutputStreamContent(String uri, ContentCreateOptions options) throws IOException {
        PipedOutputStream sink = new PipedOutputStream();
        this.sink = sink;
        this.source = new PipedInputStream(sink);
        this.content = ContentFactory.newUnBufferedContent((String)uri, (InputStream)this.source, (ContentCreateOptions)options);
    }

    public OutputStream getOutputStream() {
        return this.sink;
    }

    public String getUri() {
        return this.content.getUri();
    }

    public InputStream openDataStream() throws IOException {
        return this.source;
    }

    public ContentCreateOptions getCreateOptions() {
        return this.content.getCreateOptions();
    }

    public boolean isRewindable() {
        return false;
    }

    public void rewind() throws IOException {
        throw new IOException("Rewind is not supported");
    }

    public long size() {
        return -1L;
    }

    public void close() {
        this.content.close();
    }
}

