/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.examples;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.NumberFormat;

public class QueryHelper {
    static final int MILLIS = 1000;
    static final int SECONDS = 1000;
    static final int MINUTES = 60000;
    static final int HOURS = 3600000;

    private QueryHelper() {
    }

    static long bytesPerSecond(long totalByteCount, long elapsed) {
        return (long)((double)totalByteCount / (double)elapsed * 1000.0);
    }

    static String formatInteger(long n) {
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        return formatter.format(n);
    }

    static String formatTime(long millis) {
        StringBuffer sb = new StringBuffer();
        long n = millis / 3600000L;
        if (n != 0L) {
            sb.append(n).append("h");
        }
        if ((n = millis % 3600000L / 60000L) != 0L) {
            sb.append(n).append("m");
        }
        sb.append(millis % 60000L / 1000L).append(".");
        n = millis % 1000L;
        if (n < 100L) {
            sb.append("0");
        }
        if (n < 10L) {
            sb.append("0");
        }
        sb.append(n).append("s");
        return sb.toString();
    }

    static String loadQueryFromFile(String queryFile) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(queryFile));
        StringBuffer sb = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            sb.append(line).append("\n");
        }
        reader.close();
        return sb.toString();
    }
}

