/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.examples;

import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SemiBufferedContent
implements Content {
    private final Content delegate;
    private final File tempFile;

    public SemiBufferedContent(String uri, ContentCreateOptions options, InputStream input, int bufferSize, File directory) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int bytesRead = this.loadBuffer(input, buffer);
        if (bytesRead == buffer.length) {
            this.tempFile = this.spillContentToFile(input, buffer, directory);
            this.delegate = ContentFactory.newContent((String)uri, (File)this.tempFile, (ContentCreateOptions)options);
        } else {
            this.tempFile = null;
            this.delegate = ContentFactory.newContent((String)uri, (byte[])buffer, (int)0, (int)bytesRead, (ContentCreateOptions)options);
        }
    }

    public SemiBufferedContent(String uri, ContentCreateOptions options, InputStream input, int bufferSize) throws IOException {
        this(uri, options, input, bufferSize, null);
    }

    private File spillContentToFile(InputStream input, byte[] buffer, File directory) throws IOException {
        int rc;
        File file = File.createTempFile("XccContent", null, directory);
        FileOutputStream output = new FileOutputStream(file);
        ((OutputStream)output).write(buffer, 0, buffer.length);
        while ((rc = input.read(buffer)) > 0) {
            ((OutputStream)output).write(buffer, 0, rc);
        }
        input.close();
        output.flush();
        ((OutputStream)output).close();
        return file;
    }

    private int loadBuffer(InputStream input, byte[] buffer) throws IOException {
        int rc;
        int bytesRead = 0;
        int available = buffer.length;
        while ((rc = input.read(buffer, bytesRead, available)) > 0) {
            bytesRead += rc;
            available -= rc;
        }
        return bytesRead;
    }

    public String getUri() {
        return this.delegate.getUri();
    }

    public InputStream openDataStream() throws IOException {
        return this.delegate.openDataStream();
    }

    public ContentCreateOptions getCreateOptions() {
        return this.delegate.getCreateOptions();
    }

    public boolean isRewindable() {
        return this.delegate.isRewindable();
    }

    public void rewind() throws IOException {
        this.delegate.rewind();
    }

    public long size() {
        return this.delegate.size();
    }

    public void close() {
        this.delegate.close();
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }
}

