/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.examples;

import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentSourceFactory;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.examples.QueryHelper;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.XccConfigException;
import java.net.URI;

public class SimpleQueryRunner {
    private final Session session;
    private final AdhocQuery request;
    private RequestOptions options;

    public SimpleQueryRunner(URI serverUri) throws XccConfigException {
        ContentSource cs = ContentSourceFactory.newContentSource((URI)serverUri);
        this.session = cs.newSession();
        this.request = this.session.newAdhocQuery(null);
    }

    public ResultSequence execute(String query) throws RequestException {
        this.request.setQuery(query);
        this.request.setOptions(this.options);
        return this.session.submitRequest((Request)this.request);
    }

    public String[] executeToStringArray(String query) throws RequestException {
        ResultSequence rs = this.execute(query);
        return rs.asStrings();
    }

    public String executeToSingleString(String query, String separator) throws RequestException {
        ResultSequence rs = this.execute(query);
        String str = rs.asString(separator);
        rs.close();
        return str;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequestOptions(RequestOptions options) {
        this.options = options;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            SimpleQueryRunner.usage();
            return;
        }
        URI serverUri = new URI(args[0]);
        SimpleQueryRunner sqr = new SimpleQueryRunner(serverUri);
        sqr.options = new RequestOptions();
        for (int i = 1; i < args.length; ++i) {
            String query = QueryHelper.loadQueryFromFile(args[i]);
            if (args[i].endsWith(".js")) {
                sqr.options.setQueryLanguage("JavaScript");
            } else {
                sqr.options.setQueryLanguage("XQuery");
            }
            String result = sqr.executeToSingleString(query, System.getProperty("line.separator"));
            System.out.println(result);
        }
    }

    private static void usage() {
        System.err.println("usage: serverURL queryfile");
    }
}

