/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc;

import com.marklogic.http.HttpChannel;
import com.marklogic.xcc.ContentPermission;
import com.marklogic.xcc.DocumentFormat;
import com.marklogic.xcc.DocumentRepairLevel;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Map;

public class ContentCreateOptions
implements Cloneable {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final int MIN_BUFFER_SIZE = 256;
    public static final int MAX_BUFFER_SIZE = 0xC00000;
    private DocumentFormat format = DocumentFormat.NONE;
    private DocumentRepairLevel repairLevel = DocumentRepairLevel.DEFAULT;
    private Locale locale = null;
    private boolean resolveEntities = false;
    private int resolveBufferSize = 0;
    private ContentPermission[] permissions = null;
    private String[] collections = null;
    private int quality = 0;
    private String namespace = null;
    private BigInteger[] placeKeys = null;
    private String language = null;
    private String encoding = "UTF-8";
    private int bufferSize = -1;
    private String temporalCollection = null;
    private String temporalVersionURI = null;
    private String graph = null;
    private Map<String, String> metadata = null;

    public static ContentCreateOptions newXmlInstance() {
        ContentCreateOptions options = new ContentCreateOptions();
        options.setFormatXml();
        return options;
    }

    public static ContentCreateOptions newTextInstance() {
        ContentCreateOptions options = new ContentCreateOptions();
        options.setFormatText();
        return options;
    }

    public static ContentCreateOptions newBinaryInstance() {
        ContentCreateOptions options = new ContentCreateOptions();
        options.setFormatBinary();
        return options;
    }

    public static ContentCreateOptions newJsonInstance() {
        ContentCreateOptions options = new ContentCreateOptions();
        options.setFormatJson();
        return options;
    }

    public void setFormat(DocumentFormat format) {
        this.format = format;
    }

    public DocumentFormat getFormat() {
        return this.format;
    }

    public void setFormatXml() {
        this.setFormat(DocumentFormat.XML);
    }

    public void setFormatText() {
        this.setFormat(DocumentFormat.TEXT);
    }

    public void setFormatBinary() {
        this.setFormat(DocumentFormat.BINARY);
    }

    public void setFormatJson() {
        this.setFormat(DocumentFormat.JSON);
    }

    public DocumentRepairLevel getRepairLevel() {
        return this.repairLevel;
    }

    public void setRepairLevel(DocumentRepairLevel repairLevel) {
        this.repairLevel = repairLevel;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean getResolveEntities() {
        return this.resolveEntities;
    }

    public void setResolveEntities(boolean resolveEntities) {
        if (HttpChannel.isUseHTTP()) {
            throw new UnsupportedOperationException("ResolveEntities is not supported when \"xcc.httpcompliant\" is enabled");
        }
        this.resolveEntities = resolveEntities;
    }

    public int getResolveBufferSize() {
        return this.resolveBufferSize;
    }

    public void setResolveBufferSize(int resolveBufferSize) {
        this.resolveBufferSize = resolveBufferSize;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding == null ? DEFAULT_ENCODING : encoding;
    }

    public String[] getCollections() {
        return this.collections == null ? null : (String[])this.collections.clone();
    }

    public void setCollections(String[] collections) {
        this.collections = collections == null ? null : (String[])collections.clone();
    }

    public BigInteger[] getPlaceKeys() {
        return this.placeKeys == null ? null : (BigInteger[])this.placeKeys.clone();
    }

    public void setPlaceKeys(BigInteger[] forestKeys) {
        this.placeKeys = forestKeys == null ? null : (BigInteger[])forestKeys.clone();
    }

    public void setPlaceKeys(long[] forestKeys) {
        if (forestKeys == null) {
            this.placeKeys = null;
            return;
        }
        BigInteger[] bigInts = new BigInteger[forestKeys.length];
        for (int i = 0; i < forestKeys.length; ++i) {
            bigInts[i] = new BigInteger("" + forestKeys[i]);
        }
        this.setPlaceKeys(bigInts);
    }

    public ContentPermission[] getPermissions() {
        return this.permissions == null ? null : (ContentPermission[])this.permissions.clone();
    }

    public void setPermissions(ContentPermission[] permissions) {
        this.permissions = permissions == null ? null : (ContentPermission[])permissions.clone();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int newSize) {
        this.bufferSize = newSize < 1 ? -1 : (newSize < 256 ? 256 : (newSize > 0xC00000 ? 0xC00000 : newSize));
    }

    public String getTemporalCollection() {
        return this.temporalCollection;
    }

    public void setTemporalCollection(String temporalCollection) {
        this.temporalCollection = temporalCollection;
    }

    public String getTemporalVersionURI() {
        return this.temporalVersionURI;
    }

    public void setTemporalVersionURI(String temporalVersionURI) {
        this.temporalVersionURI = temporalVersionURI;
    }

    public String getGraph() {
        return this.graph;
    }

    public void setGraph(String graph) {
        this.graph = graph;
    }

    public Object clone() {
        int i;
        ContentCreateOptions options = new ContentCreateOptions();
        options.bufferSize = this.bufferSize;
        if (this.collections != null) {
            options.collections = new String[this.collections.length];
            for (i = 0; i < this.collections.length; ++i) {
                options.collections[i] = this.collections[i];
            }
        }
        options.encoding = this.encoding;
        options.format = this.format;
        options.language = this.language;
        options.locale = this.locale;
        options.namespace = this.namespace;
        options.temporalCollection = this.temporalCollection;
        options.temporalVersionURI = this.temporalVersionURI;
        if (this.permissions != null) {
            options.permissions = new ContentPermission[this.permissions.length];
            for (i = 0; i < this.permissions.length; ++i) {
                options.permissions[i] = this.permissions[i];
            }
        }
        if (this.placeKeys != null) {
            options.placeKeys = new BigInteger[this.placeKeys.length];
            for (i = 0; i < this.placeKeys.length; ++i) {
                options.placeKeys[i] = new BigInteger(this.placeKeys[i].toByteArray());
            }
        }
        options.quality = this.quality;
        options.repairLevel = this.repairLevel;
        options.resolveBufferSize = this.resolveBufferSize;
        options.resolveEntities = this.resolveEntities;
        options.graph = this.graph;
        options.metadata = this.metadata;
        return options;
    }
}

