/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.xcc.ContentCapability;
import com.marklogic.xcc.ContentPermission;
import com.marklogic.xcc.DocumentFormat;
import com.marklogic.xcc.exceptions.UnimplementedFeatureException;
import com.marklogic.xcc.types.XSInteger;
import com.thoughtworks.xstream.XStream;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DocumentMetadata {
    static XStream xstream = new XStream();
    public static String EXTENSION = ".metadata";
    public static String NAKED = ".naked";
    protected DocumentFormat format = DocumentFormat.XML;
    protected List<String> collectionsList = new Vector<String>();
    protected List<ContentPermission> permissionsList = new Vector<ContentPermission>();
    protected String permString = null;
    protected int quality = 0;
    protected Map<String, String> meta = null;
    protected String properties = null;
    protected boolean isNakedProps;

    public boolean isNakedProps() {
        return this.isNakedProps;
    }

    public void setNakedProps(boolean isNakedProps) {
        this.isNakedProps = isNakedProps;
    }

    public static DocumentMetadata fromXML(Reader reader) {
        xstream.allowTypes(new Class[]{DocumentMetadata.class, ContentPermission.class});
        return (DocumentMetadata)xstream.fromXML(reader);
    }

    public boolean isBinary() {
        return DocumentFormat.BINARY.toString().equals(this.format.toString());
    }

    public void setFormat(DocumentFormat _format) {
        this.format = _format;
    }

    public void addCollection(String _collection) {
        this.collectionsList.add(_collection);
    }

    public void addPermission(ContentPermission _permission) {
        this.permissionsList.add(_permission);
    }

    public void setQuality(int _quality) {
        this.quality = _quality;
    }

    public void setProperties(String _properties) {
        this.properties = _properties;
    }

    public String[] getCollections() {
        return this.collectionsList.toArray(new String[0]);
    }

    public String getCollectionString() {
        if (this.collectionsList.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < this.collectionsList.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append("\"").append(this.collectionsList.get(i)).append("\"");
        }
        buf.append("]");
        return buf.toString();
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, String> meta) {
        this.meta = meta;
    }

    public String getProperties() {
        return this.properties;
    }

    public void addPermissions(Collection<ContentPermission> permissions) {
        if (permissions == null) {
            return;
        }
        this.permissionsList.addAll(permissions);
    }

    public ContentPermission[] getPermissions() {
        if (this.permissionsList.size() < 1) {
            return null;
        }
        return this.permissionsList.toArray(new ContentPermission[0]);
    }

    public int getQuality() {
        return this.quality;
    }

    public String getQualityString() {
        return String.valueOf(this.quality);
    }

    public DocumentFormat getFormat() {
        return this.format;
    }

    public String toXML() {
        return xstream.toXML((Object)this);
    }

    public void clearPermissions() {
        this.permissionsList.clear();
    }

    public void clearProperties() {
        this.properties = null;
    }

    public String getFormatName() {
        return this.format.toString();
    }

    public void setFormat(String _format) {
        if (_format.equals(DocumentFormat.XML) || _format.equals("element") || _format.equals("comment") || _format.equals("processing-instruction")) {
            this.setFormat(DocumentFormat.XML);
            return;
        }
        if (_format.equals(DocumentFormat.TEXT) || _format.equals("text")) {
            this.setFormat(DocumentFormat.TEXT);
            return;
        }
        if (_format.equals(DocumentFormat.BINARY)) {
            this.setFormat(DocumentFormat.BINARY);
            return;
        }
        this.setFormat(DocumentFormat.JSON);
    }

    public void addPermission(String _capability, String _role, String _id) {
        ContentCapability capability;
        if (ContentPermission.UPDATE.toString().equals(_capability)) {
            capability = ContentPermission.UPDATE;
        } else if (ContentPermission.INSERT.toString().equals(_capability)) {
            capability = ContentPermission.INSERT;
        } else if (ContentPermission.EXECUTE.toString().equals(_capability)) {
            capability = ContentPermission.EXECUTE;
        } else if (ContentPermission.READ.toString().equals(_capability)) {
            capability = ContentPermission.READ;
        } else if (ContentPermission.NODE_UPDATE.toString().equals(_capability)) {
            capability = ContentPermission.NODE_UPDATE;
        } else {
            throw new UnimplementedFeatureException("unknown capability: " + _capability);
        }
        this.addPermission(new ContentPermission(capability, _role, _id));
    }

    public String getPermString() {
        if (this.permString != null) {
            return this.permString;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<perms>");
        for (ContentPermission pm : this.permissionsList) {
            buf.append("<sec:permission xmlns:sec=\"http://marklogic.com/xdmp/security\">\n");
            buf.append("  <sec:capability>");
            buf.append(pm.getCapability().toString());
            buf.append("</sec:capability>\n");
            buf.append("  <sec:role-id>");
            buf.append(pm.getId());
            buf.append("</sec:role-id>\n");
            buf.append("</sec:permission>\n");
        }
        buf.append("</perms>");
        this.permString = buf.toString();
        return this.permString;
    }

    public void setPermString(String permString) {
        this.permString = permString;
    }

    public void setQuality(XSInteger integer) {
        this.setQuality(integer.asPrimitiveInt());
    }

    public boolean isText() {
        return DocumentFormat.TEXT.toString().equals(this.format.toString());
    }

    public boolean isXml() {
        return DocumentFormat.XML.toString().equals(this.format.toString());
    }

    public void addCollections(String[] _collections) {
        if (null == _collections || 1 > _collections.length) {
            return;
        }
        for (String collection : _collections) {
            this.addCollection(collection);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof DocumentMetadata)) {
            return false;
        }
        DocumentMetadata metadata = (DocumentMetadata)obj;
        boolean result = this.compareCollections(metadata.getCollections()) && this.getFormatName().equals(metadata.getFormatName()) && this.comparePermissions(metadata.getPermissions()) && this.compareProperties(metadata.getProperties()) && this.getQuality() == metadata.getQuality() && this.meta.equals(metadata.getMeta());
        return result;
    }

    private boolean compareProperties(String properties) {
        if (this.properties == properties) {
            return true;
        }
        if (this.properties != null) {
            return this.properties.equals(properties);
        }
        return false;
    }

    private boolean compareCollections(String[] cols) {
        if (cols == null || this.collectionsList.size() != cols.length) {
            return false;
        }
        for (int i = 0; i < this.collectionsList.size(); ++i) {
            if (this.collectionsList.get(i).equals(cols[i])) continue;
            return false;
        }
        return true;
    }

    private boolean comparePermissions(ContentPermission[] p) {
        if (p == null && this.getPermissions() == null) {
            return true;
        }
        if (this.permissionsList.size() != p.length) {
            return false;
        }
        for (int i = 0; i < this.permissionsList.size(); ++i) {
            if (this.permissionsList.get(i).toString().equals(p[i].toString())) continue;
            return false;
        }
        return true;
    }
}

