/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.Command;
import com.marklogic.contentpump.ConfigConstants;
import com.marklogic.contentpump.ContentPump;
import com.marklogic.contentpump.ContentPumpReporter;
import com.marklogic.contentpump.LocalJob;
import com.marklogic.contentpump.MultithreadedMapper;
import com.marklogic.contentpump.ThreadManager;
import com.marklogic.contentpump.utilities.ReflectionUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public class LocalJobRunner
implements ConfigConstants {
    public static final Log LOG = LogFactory.getLog(LocalJobRunner.class);
    private LocalJob job;
    private AtomicInteger[] progress;
    private long startTime;
    private ContentPumpReporter reporter;
    private ThreadManager threadManager;
    private ThreadPoolExecutor pool;

    public LocalJobRunner(LocalJob job, CommandLine cmdline, Command cmd) {
        this.job = job;
        this.threadManager = job.getThreadManager();
        this.threadManager.parseCmdlineOptions(cmdline, cmd);
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <INKEY, INVALUE, OUTKEY, OUTVALUE, T extends InputSplit> void run() throws Exception {
        InputSplit[] array;
        List splits;
        Configuration conf = this.job.getConfiguration();
        this.reporter = new ContentPumpReporter();
        InputFormat inputFormat = (InputFormat)ReflectionUtils.newInstance((Class)this.job.getInputFormatClass(), (Configuration)conf);
        try {
            splits = inputFormat.getSplits((JobContext)this.job);
            array = splits.toArray(new InputSplit[splits.size()]);
            Arrays.sort(array, new SplitLengthComparator());
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error getting input splits: ", (Throwable)ex);
            } else {
                LOG.error((Object)"Error getting input splits: ");
                LOG.error((Object)ex.getMessage());
            }
            this.job.setJobState(JobStatus.State.FAILED);
            return;
        }
        OutputFormat outputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)this.job.getOutputFormatClass(), (Configuration)conf);
        Class mapperClass = this.job.getMapperClass();
        Mapper mapper = (Mapper)ReflectionUtils.newInstance((Class)mapperClass, (Configuration)conf);
        try {
            outputFormat.checkOutputSpecs((JobContext)this.job);
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error checking output specification: ", (Throwable)ex);
            } else {
                LOG.error((Object)"Error checking output specification: ");
                LOG.error((Object)ex.getMessage());
            }
            this.job.setJobState(JobStatus.State.FAILED);
            return;
        }
        this.pool = this.threadManager.initThreadPool();
        this.threadManager.runThreadPoller();
        this.progress = new AtomicInteger[splits.size()];
        for (int i = 0; i < splits.size(); ++i) {
            this.progress[i] = new AtomicInteger();
        }
        this.job.setJobState(JobStatus.State.RUNNING);
        Monitor monitor = new Monitor();
        monitor.start();
        for (int i = 0; i < array.length && !ContentPump.shutdown; ++i) {
            InputSplit split = array[i];
            if (this.pool != null) {
                LocalMapTask task = new LocalMapTask(inputFormat, outputFormat, conf, i, split, this.reporter, this.progress[i]);
                this.threadManager.submitTask(task, i, array.length);
                continue;
            }
            JobID jid = new JobID();
            TaskID taskId = new TaskID(jid.getJtIdentifier(), jid.getId(), TaskType.MAP, i);
            TaskAttemptID taskAttemptId = new TaskAttemptID(taskId, 0);
            TaskAttemptContext context = ReflectionUtil.createTaskAttemptContext(conf, taskAttemptId);
            RecordReader reader = inputFormat.createRecordReader(split, context);
            RecordWriter writer = outputFormat.getRecordWriter(context);
            OutputCommitter committer = outputFormat.getOutputCommitter(context);
            TrackingRecordReader trackingReader = new TrackingRecordReader(reader, this.progress[i]);
            Mapper.Context mapperContext = ReflectionUtil.createMapperContext(mapper, conf, taskAttemptId, trackingReader, writer, committer, this.reporter, split);
            trackingReader.initialize(split, (TaskAttemptContext)mapperContext);
            Class mapClass = this.job.getMapperClass();
            mapperContext.getConfiguration().setClass("mapreduce.job.map.class", mapClass, Mapper.class);
            mapper = (Mapper)ReflectionUtils.newInstance((Class)mapClass, (Configuration)mapperContext.getConfiguration());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Running with single thread and will not auto-scale");
            }
            try {
                mapper.run(mapperContext);
                continue;
            }
            finally {
                block31: {
                    block30: {
                        block29: {
                            try {
                                trackingReader.close();
                            }
                            catch (Throwable t) {
                                LOG.error((Object)("Error closing reader: " + t.getMessage()));
                                if (!LOG.isDebugEnabled()) break block29;
                                LOG.debug((Object)t);
                            }
                        }
                        try {
                            writer.close((TaskAttemptContext)mapperContext);
                        }
                        catch (Throwable t) {
                            LOG.error((Object)("Error closing writer: " + t.getMessage()));
                            if (!LOG.isDebugEnabled()) break block30;
                            LOG.debug((Object)t);
                        }
                    }
                    try {
                        committer.commitTask(context);
                    }
                    catch (Throwable t) {
                        LOG.error((Object)("Error committing task: " + t.getMessage()));
                        if (!LOG.isDebugEnabled()) break block31;
                        LOG.debug((Object)t);
                    }
                }
            }
        }
        this.threadManager.shutdownThreadPool();
        this.job.setJobState(JobStatus.State.SUCCEEDED);
        monitor.interrupt();
        monitor.join(1000L);
        for (CounterGroup group : this.reporter.counters) {
            LOG.info((Object)(group.getDisplayName() + ": "));
            for (Counter counter : group) {
                LOG.info((Object)(counter.getDisplayName() + ": " + counter.getValue()));
            }
        }
        LOG.info((Object)("Total execution time: " + (System.currentTimeMillis() - this.startTime) / 1000L + " sec"));
    }

    public double computeProgress() {
        if (this.progress.length == 0) {
            return 1.0;
        }
        long result = 0L;
        for (AtomicInteger pct : this.progress) {
            result += pct.longValue();
        }
        return (double)result / (double)this.progress.length / 100.0;
    }

    public ContentPumpReporter getReporter() {
        return this.reporter;
    }

    private static class SplitLengthComparator
    implements Comparator<InputSplit> {
        private SplitLengthComparator() {
        }

        @Override
        public int compare(InputSplit o1, InputSplit o2) {
            try {
                long len1 = o1.getLength();
                long len2 = o2.getLength();
                if (len1 < len2) {
                    return 1;
                }
                if (len1 == len2) {
                    return 0;
                }
                return -1;
            }
            catch (IOException ie) {
                throw new RuntimeException("exception in compare", ie);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException("exception in compare", ie);
            }
        }
    }

    class Monitor
    extends Thread {
        private String lastReport;

        Monitor() {
        }

        @Override
        public void run() {
            String report;
            try {
                while (!(ContentPump.shutdown || Monitor.interrupted() || LocalJobRunner.this.job.done())) {
                    Thread.sleep(1000L);
                    if (!ContentPump.shutdown) {
                        report = " completed " + StringUtils.formatPercent((double)LocalJobRunner.this.computeProgress(), (int)0);
                        if (report.equals(this.lastReport)) continue;
                        LOG.info((Object)report);
                        this.lastReport = report;
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException report2) {
            }
            catch (Throwable t) {
                LOG.error((Object)"Error in monitor thread", t);
            }
            report = " completed " + StringUtils.formatPercent((double)LocalJobRunner.this.computeProgress(), (int)0);
            if (!report.equals(this.lastReport)) {
                LOG.info((Object)report);
            }
        }
    }

    class TrackingRecordReader<K, V>
    extends RecordReader<K, V> {
        private final RecordReader<K, V> real;
        private AtomicInteger pctProgress;

        TrackingRecordReader(RecordReader<K, V> real, AtomicInteger pctProgress) {
            this.real = real;
            this.pctProgress = pctProgress;
        }

        public void close() throws IOException {
            this.real.close();
        }

        public K getCurrentKey() throws IOException, InterruptedException {
            return (K)this.real.getCurrentKey();
        }

        public V getCurrentValue() throws IOException, InterruptedException {
            return (V)this.real.getCurrentValue();
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.real.getProgress();
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.real.initialize(split, context);
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            boolean result = this.real.nextKeyValue();
            this.pctProgress.set((int)(this.getProgress() * 100.0f));
            return result;
        }
    }

    public class LocalMapTask<INKEY, INVALUE, OUTKEY, OUTVALUE>
    implements Callable<Object> {
        private InputFormat<INKEY, INVALUE> inputFormat;
        private OutputFormat<OUTKEY, OUTVALUE> outputFormat;
        private Mapper<INKEY, INVALUE, OUTKEY, OUTVALUE> mapper;
        private Configuration conf;
        private int id;
        private InputSplit split;
        private AtomicInteger pctProgress;
        private ContentPumpReporter reporter;
        private Class<? extends Mapper<?, ?, ?, ?>> mapperClass;
        private int threadCount = 0;
        private AtomicBoolean isTaskDone = new AtomicBoolean(false);

        public LocalMapTask(InputFormat<INKEY, INVALUE> inputFormat, OutputFormat<OUTKEY, OUTVALUE> outputFormat, Configuration conf, int id, InputSplit split, ContentPumpReporter reporter, AtomicInteger pctProgress) {
            this.inputFormat = inputFormat;
            this.outputFormat = outputFormat;
            this.conf = conf;
            this.id = id;
            this.split = split;
            this.pctProgress = pctProgress;
            this.reporter = reporter;
            try {
                this.mapperClass = LocalJobRunner.this.job.getMapperClass();
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)"Mapper class not found", (Throwable)e);
            }
        }

        public void setThreadCount(int threads) {
            this.threadCount = threads;
        }

        public int getThreadCount() {
            return this.threadCount;
        }

        public Class<? extends Mapper<?, ?, ?, ?>> getMapperClass() {
            return this.mapperClass;
        }

        public void setMapperClass(Class<? extends Mapper<?, ?, ?, ?>> runtimeMapperClass) {
            this.mapperClass = runtimeMapperClass;
        }

        public Mapper<INKEY, INVALUE, OUTKEY, OUTVALUE> getMapper() {
            return this.mapper;
        }

        public boolean isTaskDone() {
            return this.isTaskDone.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() {
            block20: {
                OutputCommitter committer;
                TaskAttemptContext context;
                block19: {
                    RecordWriter writer;
                    Mapper.Context mapperContext;
                    block18: {
                        context = null;
                        mapperContext = null;
                        TrackingRecordReader trackingReader = null;
                        writer = null;
                        committer = null;
                        JobID jid = new JobID();
                        TaskID taskId = new TaskID(jid.getJtIdentifier(), jid.getId(), TaskType.MAP, this.id);
                        TaskAttemptID taskAttemptId = new TaskAttemptID(taskId, 0);
                        try {
                            context = ReflectionUtil.createTaskAttemptContext(this.conf, taskAttemptId);
                            RecordReader reader = this.inputFormat.createRecordReader(this.split, context);
                            writer = this.outputFormat.getRecordWriter(context);
                            committer = this.outputFormat.getOutputCommitter(context);
                            trackingReader = new TrackingRecordReader(reader, this.pctProgress);
                            this.mapper = (Mapper)ReflectionUtils.newInstance(this.mapperClass, (Configuration)this.conf);
                            mapperContext = ReflectionUtil.createMapperContext(this.mapper, this.conf, taskAttemptId, trackingReader, writer, committer, this.reporter, this.split);
                            trackingReader.initialize(this.split, (TaskAttemptContext)mapperContext);
                            if (this.mapperClass == MultithreadedMapper.class) {
                                ((MultithreadedMapper)this.mapper).setThreadCount(this.threadCount);
                                ((MultithreadedMapper)this.mapper).setThreadPool(LocalJobRunner.this.pool);
                            }
                            this.mapper.run(mapperContext);
                        }
                        catch (Throwable t) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Error running task: ", t);
                            } else {
                                LOG.error((Object)"Error running task: ");
                                LOG.error((Object)t.getMessage());
                            }
                            try {
                                ThreadPoolExecutor threadPoolExecutor = LocalJobRunner.this.pool;
                                synchronized (threadPoolExecutor) {
                                    LocalJobRunner.this.pool.notify();
                                }
                            }
                            catch (Throwable t1) {
                                LOG.error((Object)t1);
                            }
                        }
                        try {
                            if (trackingReader != null) {
                                trackingReader.close();
                            }
                        }
                        catch (Throwable t) {
                            LOG.error((Object)("Error closing reader: " + t.getMessage()));
                            if (!LOG.isDebugEnabled()) break block18;
                            LOG.debug((Object)t);
                        }
                    }
                    try {
                        if (writer != null) {
                            writer.close(mapperContext);
                        }
                    }
                    catch (Throwable t) {
                        LOG.error((Object)("Error closing writer: " + t.getMessage()));
                        if (!LOG.isDebugEnabled()) break block19;
                        LOG.debug((Object)t);
                    }
                }
                try {
                    committer.commitTask(context);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error committing task: " + t.getMessage()));
                    if (!LOG.isDebugEnabled()) break block20;
                    LOG.debug((Object)t);
                }
            }
            this.isTaskDone.set(true);
            return null;
        }
    }
}

