/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump.utilities;

import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.exceptions.XccConfigException;
import com.marklogic.xcc.types.ValueType;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;

public class AuditUtil {
    public static final Log LOG = LogFactory.getLog(AuditUtil.class);

    public static void prepareAuditMlcpFinish(Configuration conf, int ruleCount) {
        StringBuilder buf = new StringBuilder();
        buf.append("(Redaction Counters) Applicable rules found=");
        buf.append(ruleCount);
        conf.set("mapreduce.marklogic.audit.mlcpfinish.message", buf.toString());
    }

    public static void auditMlcpFinish(Configuration conf, String jobName, Counters counters) throws IOException {
        String ruleCounter;
        boolean success = false;
        if (!conf.getBoolean("mapreduce.marklogic.audit.mlcpfinish.enabled", false)) {
            return;
        }
        StringBuilder auditBuf = new StringBuilder();
        auditBuf.append("job=");
        auditBuf.append(jobName);
        if (counters.countCounters() > 0) {
            auditBuf.append(";");
            Iterator groupIt = counters.iterator();
            int groupCounter = 0;
            while (groupIt.hasNext()) {
                CounterGroup group = (CounterGroup)groupIt.next();
                if (groupCounter != 0) {
                    auditBuf.append("; ");
                } else {
                    auditBuf.append(" ");
                }
                auditBuf.append('(');
                auditBuf.append(group.getDisplayName());
                auditBuf.append(") ");
                Iterator counterIt = group.iterator();
                int counterCount = 0;
                while (counterIt.hasNext()) {
                    if (counterCount != 0) {
                        auditBuf.append(", ");
                    }
                    Counter counter = (Counter)counterIt.next();
                    auditBuf.append(counter.getDisplayName());
                    auditBuf.append('=');
                    auditBuf.append(counter.getValue());
                    ++counterCount;
                }
                ++groupCounter;
            }
            success = true;
        }
        if ((ruleCounter = conf.get("mapreduce.marklogic.audit.mlcpfinish.message")) != null) {
            auditBuf.append("; ");
            auditBuf.append(ruleCounter);
        }
        String auditMessage = auditBuf.toString();
        auditBuf = new StringBuilder();
        auditBuf.append("xquery version \"1.0-ml\";\n");
        auditBuf.append("declare variable $success as xs:boolean external;\n");
        auditBuf.append("xdmp:audit(\"");
        auditBuf.append("mlcpcopyexportfinish");
        auditBuf.append("\",\"");
        auditBuf.append(auditMessage);
        auditBuf.append("\", ");
        auditBuf.append("xdmp:get-current-user(), $success)");
        String auditQueryStr = auditBuf.toString();
        Session auditSession = null;
        ContentSource auditCs = null;
        try {
            auditCs = InternalUtilities.getInputContentSource(conf);
            auditSession = auditCs.newSession();
            RequestOptions options = new RequestOptions();
            options.setCacheResult(false);
            AdhocQuery auditQuery = auditSession.newAdhocQuery(auditQueryStr);
            auditQuery.setOptions(options);
            auditQuery.setNewVariable("success", (ValueType)ValueType.XS_BOOLEAN, (Object)new Boolean(success));
            auditSession.submitRequest((Request)auditQuery);
        }
        catch (XccConfigException e) {
            LOG.error((Object)e);
            throw new IOException(e);
        }
        catch (URISyntaxException e) {
            LOG.error((Object)e);
            throw new IOException(e);
        }
        catch (RequestException e) {
            LOG.error((Object)e);
            LOG.error((Object)("Query: " + auditQueryStr));
            throw new IOException(e);
        }
    }

    public static void prepareAuditMlcpStart(Job job, String cmd, CommandLine cmdline) {
        Configuration conf = job.getConfiguration();
        StringBuilder buf = new StringBuilder();
        buf.append(cmd);
        buf.append(" ");
        Option[] options = cmdline.getOptions();
        for (int i = 0; i < options.length; ++i) {
            String name = options[i].getOpt();
            if (name.matches(".*password")) continue;
            if (i != 0) {
                buf.append(' ');
            }
            buf.append('-');
            buf.append(name);
            String value = cmdline.getOptionValue(name);
            if (value == null) continue;
            buf.append(' ');
            buf.append(value);
        }
        conf.set("mapreduce.marklogic.audit.mlcpstart.message", buf.toString());
    }

    public static void auditMlcpStart(Configuration conf, String jobName) throws IOException {
        String mlcpStartMessage = conf.get("mapreduce.marklogic.audit.mlcpstart.message");
        StringBuilder auditBuf = new StringBuilder();
        auditBuf.append("job=");
        auditBuf.append(jobName);
        auditBuf.append("; ");
        if (mlcpStartMessage != null) {
            auditBuf.append(mlcpStartMessage);
        }
        String auditMessage = auditBuf.toString();
        auditBuf = new StringBuilder();
        if (auditMessage != null) {
            auditBuf.append("xquery version \"1.0-ml\";\n");
            auditBuf.append("xdmp:audit(\"");
            auditBuf.append("mlcpcopyexportstart");
            auditBuf.append("\",\"");
            auditBuf.append(auditMessage);
            auditBuf.append("\", xdmp:get-current-user())");
            String auditQueryStr = auditBuf.toString();
            Session auditSession = null;
            ContentSource auditCs = null;
            try {
                auditCs = InternalUtilities.getInputContentSource(conf);
                auditSession = auditCs.newSession();
                RequestOptions options = new RequestOptions();
                options.setCacheResult(false);
                AdhocQuery auditQuery = auditSession.newAdhocQuery(auditQueryStr);
                auditQuery.setOptions(options);
                auditSession.submitRequest((Request)auditQuery);
            }
            catch (XccConfigException e) {
                LOG.error((Object)e);
                throw new IOException(e);
            }
            catch (URISyntaxException e) {
                LOG.error((Object)e);
                throw new IOException(e);
            }
            catch (RequestException e) {
                LOG.error((Object)e);
                LOG.error((Object)("Query: " + auditQueryStr));
                throw new IOException(e);
            }
        }
    }
}

