/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.dom;

import com.marklogic.dom.NodeImpl;
import com.marklogic.tree.ExpandedTree;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public class AttrImpl
extends NodeImpl
implements Attr {
    public static final Log LOG = LogFactory.getLog(AttrImpl.class);

    public AttrImpl(ExpandedTree tree, int node) {
        super(tree, node);
    }

    @Override
    protected Node cloneNode(Document doc, boolean deep) {
        Attr attr = doc.createAttributeNS(this.getNamespaceURI(), this.getLocalName());
        attr.setValue(this.getValue());
        attr.setPrefix(this.getPrefix());
        return attr;
    }

    protected int getNodeID() {
        return this.tree.attrNodeNodeNameRepID[this.tree.nodeRepID[this.node]];
    }

    @Override
    public String getLocalName() {
        return this.tree.atomString(this.tree.nodeNameNameAtom[this.getNodeID()]);
    }

    @Override
    public String getName() {
        String prefix = this.getPrefix();
        return prefix == null || prefix.equals("") ? this.getLocalName() : prefix + ":" + this.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.tree.atomString(this.tree.nodeNameNamespaceAtom[this.getNodeID()]);
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    @Override
    public Element getOwnerElement() {
        return (Element)this.tree.node(this.tree.nodeParentNodeRepID[this.node]);
    }

    @Override
    protected int getPrefixID(int uriAtom) {
        int parentNodeRepID = this.tree.nodeParentNodeRepID[this.node];
        if (parentNodeRepID == -1) {
            parentNodeRepID = this.node;
        }
        ArrayList<Integer> ubp = new ArrayList<Integer>();
        long sum_ordinal = this.tree.ordinal + this.tree.nodeOrdinal[parentNodeRepID];
        int ns = this.getNSNodeID(sum_ordinal);
        while (ns >= 0) {
            int uri = this.tree.nsNodeUriAtom[ns];
            int prefix = this.tree.nsNodePrefixAtom[ns];
            if (this.tree.atomString(uri) == null) {
                ubp.add(prefix);
            } else if (uri == uriAtom && !ubp.contains(prefix) && this.tree.atomString(prefix) != null) {
                return prefix;
            }
            ns = this.nextNSNodeID(ns, 0L);
        }
        return -1;
    }

    @Override
    public String getPrefix() {
        int ns = this.tree.nodeNameNamespaceAtom[this.tree.attrNodeNodeNameRepID[this.tree.nodeRepID[this.node]]];
        if (ns < 0) {
            return null;
        }
        String preserved = this.builtinNSPrefix(this.getNamespaceURI());
        if (preserved != null) {
            return preserved;
        }
        if (this.tree.atomString(ns) != null) {
            ns = this.getPrefixID(ns);
        }
        return ns >= 0 ? this.tree.atomString(ns) : null;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public boolean getSpecified() {
        return true;
    }

    @Override
    public String getValue() {
        return this.tree.getText(this.tree.attrNodeTextRepID[this.tree.nodeRepID[this.node]]);
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.getOwnerElement().lookupNamespaceURI(prefix);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return this.getOwnerElement().lookupPrefix(namespaceURI);
    }

    @Override
    public void setValue(String value) throws DOMException {
        throw new DOMException(7, null);
    }
}

