/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.dom;

import com.marklogic.dom.ElementImpl;
import com.marklogic.tree.ExpandedTree;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeNodeMapImpl
implements NamedNodeMap {
    public static final Log LOG = LogFactory.getLog(AttributeNodeMapImpl.class);
    protected ElementImpl element;
    protected Attr[] nsDecl;
    private static DocumentBuilderFactory dbf = null;

    public AttributeNodeMapImpl(ElementImpl element) {
        this.element = element;
    }

    @Override
    public int getLength() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.element.getNodeName() + "@NumAttr:" + this.getNumAttr() + " NumNSDecl:" + this.element.getNumNSDecl()));
        }
        return this.getNumAttr() + this.element.getNumNSDecl();
    }

    protected int getNumAttr() {
        int num = this.element.tree.elemNodeNumAttributes[this.element.tree.nodeRepID[this.element.node]];
        return num >= 0 ? num : 0;
    }

    @Override
    public Node getNamedItem(String name) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.getClass().getSimpleName() + ".getNamedItem(" + this.element.node + ", " + name + ")"));
        }
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            if (!name.equals(this.item(i).getNodeName())) continue;
            return this.item(i);
        }
        return null;
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.getClass().getSimpleName() + ".getNamedItemNS(" + this.element.node + ", " + namespaceURI + ", " + localName + ")"));
        }
        if (localName == null) {
            return null;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            if (namespaceURI == null != (this.item(i).getNamespaceURI() == null) || namespaceURI != null && !namespaceURI.equals(this.item(i).getNamespaceURI()) || !localName.equals(this.item(i).getLocalName())) continue;
            return this.item(i);
        }
        return null;
    }

    private static synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        if (dbf == null) {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
        }
        return dbf;
    }

    protected Document getClonedOwnerDoc() throws ParserConfigurationException {
        return AttributeNodeMapImpl.getDocumentBuilderFactory().newDocumentBuilder().newDocument();
    }

    @Override
    public Node item(int index) {
        try {
            return this.item(index, null);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    protected Node item(int index, Document ownerDoc) throws ParserConfigurationException {
        int count;
        int numAttr = this.getNumAttr();
        ExpandedTree tree = this.element.tree;
        if (index < numAttr) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.getClass().getSimpleName() + ".item(" + this.element.node + ", " + index + ")"));
            }
            return tree.node(tree.elemNodeAttrNodeRepID[tree.nodeRepID[this.element.node]] + index);
        }
        int nsIdx = index - numAttr;
        if (this.nsDecl != null) {
            return this.nsDecl[nsIdx];
        }
        if (ownerDoc == null) {
            ownerDoc = this.getClonedOwnerDoc();
        }
        this.nsDecl = new Attr[this.element.getNumNSDecl()];
        long minimal = tree.nodeOrdinal[this.element.node];
        int ns = this.element.getNSNodeID(minimal, minimal);
        for (count = 0; ns >= 0 && count < this.element.getNumNSDecl(); ++count) {
            String uri = tree.atomString(tree.nsNodeUriAtom[ns]);
            String prefix = tree.atomString(tree.nsNodePrefixAtom[ns]);
            Attr attr = null;
            Object name = null;
            try {
                name = prefix != null && !"".equals(prefix) ? "xmlns:" + prefix : "xmlns";
                attr = ownerDoc.createAttributeNS("http://www.w3.org/2000/xmlns/", (String)name);
                attr.setValue(uri);
            }
            catch (DOMException e) {
                throw new RuntimeException(e);
            }
            this.nsDecl[count] = attr;
            ns = this.element.nextNSNodeID(ns, minimal);
        }
        if (this.nsDecl != null && nsIdx < count) {
            return this.nsDecl[nsIdx];
        }
        return null;
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public Node setNamedItem(Node arg) throws DOMException {
        throw new DOMException(7, null);
    }

    @Override
    public Node setNamedItemNS(Node arg) throws DOMException {
        throw new DOMException(7, null);
    }
}

