/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.ForestDocument;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import java.io.IOException;
import java.io.InputStream;

public abstract class BinaryDocument
extends ForestDocument {
    @Override
    public Content createContent(String uri, ContentCreateOptions options, boolean copyCollections, boolean copyMetadata, boolean copyQuality) throws IOException {
        if (copyCollections || copyMetadata || copyQuality) {
            this.setContentOptions(options, copyCollections, copyMetadata, copyQuality);
        }
        if (this.isStreamable()) {
            InputStream is = null;
            try {
                is = this.getContentAsByteStream();
                return ContentFactory.newUnBufferedContent((String)uri, (InputStream)is, (ContentCreateOptions)options);
            }
            catch (Exception ex) {
                if (is != null) {
                    is.close();
                }
                throw new IOException("Error accessing large binary document " + uri + ", skipping...", ex);
            }
        }
        return ContentFactory.newContent((String)uri, (byte[])this.getContentAsByteArray(), (ContentCreateOptions)options);
    }
}

