/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.xcc.DocumentFormat;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public enum ContentType {
    XML{

        @Override
        public DocumentFormat getDocumentFormat() {
            return DocumentFormat.XML;
        }

        @Override
        public Class<? extends Writable> getWritableClass() {
            return Text.class;
        }
    }
    ,
    JSON{

        @Override
        public DocumentFormat getDocumentFormat() {
            return DocumentFormat.JSON;
        }

        @Override
        public Class<? extends Writable> getWritableClass() {
            return Text.class;
        }
    }
    ,
    TEXT{

        @Override
        public DocumentFormat getDocumentFormat() {
            return DocumentFormat.TEXT;
        }

        @Override
        public Class<? extends Writable> getWritableClass() {
            return Text.class;
        }
    }
    ,
    BINARY{

        @Override
        public DocumentFormat getDocumentFormat() {
            return DocumentFormat.BINARY;
        }

        @Override
        public Class<? extends Writable> getWritableClass() {
            return BytesWritable.class;
        }
    }
    ,
    UNKNOWN{

        @Override
        public DocumentFormat getDocumentFormat() {
            return DocumentFormat.NONE;
        }

        @Override
        public Class<? extends Writable> getWritableClass() {
            return BytesWritable.class;
        }
    }
    ,
    MIXED{

        @Override
        public DocumentFormat getDocumentFormat() {
            return DocumentFormat.NONE;
        }

        @Override
        public Class<? extends Writable> getWritableClass() {
            return BytesWritable.class;
        }
    };


    public abstract DocumentFormat getDocumentFormat();

    public abstract Class<? extends Writable> getWritableClass();

    public static ContentType forName(String typeName) {
        if (typeName.equalsIgnoreCase(XML.name())) {
            return XML;
        }
        if (typeName.equalsIgnoreCase(JSON.name())) {
            return JSON;
        }
        if (typeName.equalsIgnoreCase(TEXT.name())) {
            return TEXT;
        }
        if (typeName.equalsIgnoreCase(BINARY.name())) {
            return BINARY;
        }
        if (typeName.equalsIgnoreCase(UNKNOWN.name())) {
            return UNKNOWN;
        }
        if (typeName.equalsIgnoreCase(MIXED.name())) {
            return MIXED;
        }
        throw new IllegalArgumentException("Unknown content type: " + typeName);
    }

    public static ContentType valueOf(int ordinal) {
        switch (ordinal) {
            case 0: {
                return XML;
            }
            case 1: {
                return JSON;
            }
            case 2: {
                return TEXT;
            }
            case 3: {
                return BINARY;
            }
            case 4: {
                return UNKNOWN;
            }
            case 5: {
                return MIXED;
            }
        }
        return null;
    }

    public static ContentType fromFormat(DocumentFormat format) {
        if (format == DocumentFormat.BINARY) {
            return BINARY;
        }
        if (format == DocumentFormat.JSON) {
            return JSON;
        }
        if (format == DocumentFormat.NONE) {
            return UNKNOWN;
        }
        if (format == DocumentFormat.TEXT) {
            return TEXT;
        }
        if (format == DocumentFormat.XML) {
            return XML;
        }
        throw new IllegalArgumentException("Unknown document format: " + format);
    }
}

