/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.DatabaseDocument;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.MarkLogicRecordReader;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.xcc.ResultItem;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;

public class DocumentReader<VALUEIN>
extends MarkLogicRecordReader<DocumentURI, VALUEIN> {
    static final float DOCUMENT_TO_FRAGMENT_RATIO = 1.0f;
    private DocumentURI currentKey;
    private VALUEIN currentValue;
    private Class<? extends Writable> valueClass;

    public DocumentReader(Configuration conf) {
        super(conf);
        this.valueClass = conf.getClass("mapreduce.marklogic.input.valueclass", DatabaseDocument.class, Writable.class);
    }

    public DocumentURI getCurrentKey() throws IOException, InterruptedException {
        return this.currentKey;
    }

    @Override
    protected void endOfResult() {
        this.currentKey = null;
        this.currentValue = null;
    }

    @Override
    protected boolean nextResult(ResultItem result) {
        if (this.currentKey != null) {
            this.currentKey.setUri(result.getDocumentURI());
        } else {
            this.currentKey = new DocumentURI(result.getDocumentURI());
        }
        if (this.currentValue == null) {
            this.currentValue = ReflectionUtils.newInstance(this.valueClass, (Configuration)this.getConf());
        }
        InternalUtilities.assignResultValue(this.valueClass, result, this.currentValue);
        return true;
    }

    public VALUEIN getCurrentValue() throws IOException, InterruptedException {
        return this.currentValue;
    }

    @Override
    protected float getDefaultRatio() {
        return 1.0f;
    }
}

