/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import com.marklogic.mapreduce.BinaryDocument;
import com.marklogic.mapreduce.ContentType;
import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.tree.ExpandedTree;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hadoop.io.Text;

public class RegularBinaryDocument
extends BinaryDocument {
    private int[] binaryData;
    private int size = 0;

    public RegularBinaryDocument() {
    }

    public RegularBinaryDocument(ExpandedTree tree) {
        this.size = tree.binaryData.length;
        this.binaryData = tree.binaryData;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.size = in.readInt();
        this.binaryData = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.binaryData[i] = in.readInt();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeInt(this.binaryData[i]);
        }
    }

    @Override
    public byte[] getContentAsByteArray() {
        ByteBuffer buf = ByteBuffer.allocate(this.size * 4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        for (int i : this.binaryData) {
            buf.putInt(i);
        }
        return buf.array();
    }

    @Override
    public MarkLogicNode getContentAsMarkLogicNode() {
        throw new UnsupportedOperationException("Cannot convert binary data to MarkLogicNode.");
    }

    @Override
    public Text getContentAsText() {
        throw new UnsupportedOperationException("Cannot convert binary data to Text.");
    }

    @Override
    public ContentType getContentType() {
        return ContentType.BINARY;
    }

    @Override
    public String getContentAsString() throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("Cannot convert binary data to String.");
    }

    @Override
    public long getContentSize() {
        return Long.valueOf(this.size) * 4L;
    }
}

