/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipEntryInputStream
extends InputStream {
    public static final Log LOG = LogFactory.getLog(ZipEntryInputStream.class);
    private ZipInputStream zipIn;
    private String fileName;
    private String entryName;

    public ZipEntryInputStream(ZipInputStream zipIn, String fileName) {
        this.zipIn = zipIn;
        this.fileName = fileName;
        this.hasNext();
    }

    public boolean hasNext() {
        try {
            ZipEntry entry;
            while ((entry = this.zipIn.getNextEntry()) != null) {
                if (entry.getSize() <= 0L) continue;
                this.entryName = entry.getName();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Zip entry name: " + this.entryName));
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            LOG.error((Object)("Error getting next zip entry from " + this.fileName), (Throwable)e);
            return false;
        }
    }

    @Override
    public int read() throws IOException {
        int bytes = this.zipIn.read();
        if (bytes == -1) {
            this.hasNext();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("bytes read from " + this.fileName + " " + this.entryName + ": " + bytes));
        }
        return bytes;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        int bytes = this.zipIn.read(buf);
        if (bytes == -1) {
            this.hasNext();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("bytes read from " + this.fileName + " " + this.entryName + ": " + bytes));
        }
        return bytes;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytes = this.zipIn.read();
        if (bytes == -1) {
            this.hasNext();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("bytes read from " + this.fileName + " " + this.entryName + ": " + bytes));
        }
        return bytes;
    }

    @Override
    public void close() {
    }

    public void closeZipInputStream() throws IOException {
        if (this.zipIn != null) {
            this.zipIn.close();
        }
    }
}

