/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.examples;

import com.marklogic.mapreduce.DocumentInputFormat;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.examples.BinaryOutputFormat;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class BinaryReader {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        if (args.length < 2) {
            System.err.println("Usage: BinaryReader configFile outputDir");
            System.exit(2);
        }
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        Job job = Job.getInstance((Configuration)conf, (String)"binary reader");
        job.setJarByClass(BinaryReader.class);
        job.setInputFormatClass(DocumentInputFormat.class);
        job.setMapperClass(DocMapper.class);
        job.setMapOutputKeyClass(DocumentURI.class);
        job.setMapOutputValueClass(BytesWritable.class);
        job.setOutputFormatClass(BinaryOutputFormat.class);
        job.setOutputKeyClass(DocumentURI.class);
        job.setOutputValueClass(BytesWritable.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(otherArgs[1]));
        conf = job.getConfiguration();
        conf.addResource(otherArgs[0]);
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class DocMapper
    extends Mapper<DocumentURI, BytesWritable, DocumentURI, BytesWritable> {
        public static final Log LOG = LogFactory.getLog(DocMapper.class);

        public void map(DocumentURI key, BytesWritable value, Mapper.Context context) throws IOException, InterruptedException {
            if (key != null && value != null) {
                LOG.debug((Object)("value length: " + value.getLength()));
                context.write((Object)key, (Object)value);
            } else {
                LOG.error((Object)("key: " + key + ", value: " + value));
            }
        }
    }
}

