/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.examples;

import com.marklogic.mapreduce.DocumentURI;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

class BinaryWriter
extends RecordWriter<DocumentURI, BytesWritable> {
    Path dir;
    Configuration conf;

    public BinaryWriter(Path path, Configuration conf) {
        this.dir = path;
        this.conf = conf;
    }

    public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
    }

    public void write(DocumentURI uri, BytesWritable content) throws IOException, InterruptedException {
        String pathStr = this.dir.getName() + uri.getUri();
        Path path = new Path(pathStr);
        FileSystem fs = path.getFileSystem(this.conf);
        FSDataOutputStream out = fs.create(path, false);
        System.out.println("writing to: " + path);
        out.write(content.getBytes(), 0, content.getLength());
        out.flush();
        out.close();
    }
}

