/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.examples;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.w3c.dom.Document;

class LinkRecordReader
extends RecordReader<IntWritable, Text> {
    private static final String PATH_EXPRESSION = "//wp:a[@title and @href and not (starts-with(@href, '#') or starts-with(@href, 'http://') or starts-with(@href, 'File:')  or starts-with(@href, 'Image:'))]/@title";
    private IntWritable key;
    private Text value;
    private int count = 0;
    private List<XdmItem> items;
    private static final ThreadLocal<DocumentBuilder> builderLocal = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            try {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                return null;
            }
        }
    };
    private static Processor proc = new Processor(false);
    private static final ThreadLocal<net.sf.saxon.s9api.DocumentBuilder> saxonBuilderLocal = new ThreadLocal<net.sf.saxon.s9api.DocumentBuilder>(){

        @Override
        protected net.sf.saxon.s9api.DocumentBuilder initialValue() {
            return proc.newDocumentBuilder();
        }
    };

    LinkRecordReader() {
    }

    public void close() throws IOException {
    }

    public IntWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        if (this.items != null) {
            return (float)this.count / (float)this.items.size();
        }
        return 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(InputSplit inSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        Path file = ((FileSplit)inSplit).getPath();
        FileSystem fs = file.getFileSystem(context.getConfiguration());
        DocumentBuilder docBuilder = builderLocal.get();
        try (FSDataInputStream fileIn = fs.open(file);){
            Document document = docBuilder.parse((InputStream)fileIn);
            net.sf.saxon.s9api.DocumentBuilder db = saxonBuilderLocal.get();
            XdmNode xdmDoc = db.wrap((Object)document);
            XPathCompiler xpath = proc.newXPathCompiler();
            xpath.declareNamespace("wp", "http://www.mediawiki.org/xml/export-0.4/");
            XPathSelector selector = xpath.compile(PATH_EXPRESSION).load();
            selector.setContextItem((XdmItem)xdmDoc);
            this.items = new ArrayList<XdmItem>();
            for (XdmItem item : selector) {
                this.items.add(item);
            }
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.items.size() > this.count) {
            if (this.key == null) {
                this.key = new IntWritable();
            }
            this.key.set(this.count);
            if (this.value == null) {
                this.value = new Text();
            }
            this.value.set(this.items.get(this.count++).getStringValue());
            return true;
        }
        return false;
    }
}

