/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.test;

import com.marklogic.mapreduce.KeyValueOutputFormat;
import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.mapreduce.NodeInputFormat;
import com.marklogic.mapreduce.NodePath;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.GenericOptionsParser;

public class CustomQuery {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        if (args.length < 1) {
            System.err.println("Usage: CustomQuery configFile");
            System.exit(2);
        }
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        Job job = Job.getInstance((Configuration)conf, (String)"custom query");
        job.setJarByClass(CustomQuery.class);
        job.setInputFormatClass(NodeInputFormat.class);
        job.setMapperClass(QueryMapper.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(Text.class);
        job.setReducerClass(QueryReducer.class);
        job.setOutputFormatClass(KeyValueOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        conf = job.getConfiguration();
        conf.addResource(otherArgs[0]);
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class QueryReducer
    extends Reducer<IntWritable, Text, Text, Text> {
        public static final Log LOG = LogFactory.getLog(QueryReducer.class);
        private Text uri = new Text();
        private Text content = new Text();

        public void reduce(IntWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            StringBuilder buf = new StringBuilder();
            buf.append("<archives>");
            for (Text val : values) {
                buf.append("<archive>\n").append(val).append("</archive>\n");
            }
            buf.append("</archives>");
            this.content.set(buf.toString());
            this.uri.set("/queryReducer/example/archive");
            context.write((Object)this.uri, (Object)this.content);
        }
    }

    public static class QueryMapper
    extends Mapper<NodePath, MarkLogicNode, IntWritable, Text> {
        public static final Log LOG = LogFactory.getLog(QueryMapper.class);
        private static final IntWritable one = new IntWritable(1);
        private Text docStr = new Text();

        public void map(NodePath key, MarkLogicNode value, Mapper.Context context) throws IOException, InterruptedException {
            if (key != null && value != null && value.get() != null) {
                if (value.get().getNodeType() == 9) {
                    String text = this.removeHeader(value.toString());
                    System.out.println(text);
                    this.docStr.set(text);
                    context.write((Object)one, (Object)this.docStr);
                }
            } else {
                LOG.error((Object)("key: " + key + ", value: " + value));
            }
        }

        private String removeHeader(String s) {
            int index = s.indexOf(">");
            if (index == -1) {
                return s;
            }
            return s.substring(index + 1);
        }
    }
}

