/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.mapreduce.utilities;

import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.utilities.AssignmentPolicy;
import java.util.concurrent.PriorityBlockingQueue;

public class StatisticalAssignmentPolicy
extends AssignmentPolicy {
    private PriorityBlockingQueue<Stats> pq;
    private long[] frmtCount;
    private int batch;

    public StatisticalAssignmentPolicy(long[] stats, int batch) {
        this.policy = AssignmentPolicy.Kind.STATISTICAL;
        this.frmtCount = new long[stats.length];
        this.batch = batch;
        this.pq = new PriorityBlockingQueue(stats.length);
        for (int i = 0; i < stats.length; ++i) {
            this.pq.add(new Stats(i, stats[i]));
            this.frmtCount[i] = stats[i];
        }
    }

    private int popAndInsert() throws InterruptedException {
        Stats min = this.pq.take();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("picked forest# " + min.fIdx + " with " + min.frmtCount + " docs"));
        }
        min.frmtCount += (long)this.batch;
        this.pq.offer(min);
        int idx = min.fIdx;
        this.frmtCount[idx] = min.frmtCount;
        return idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStats(int fIdx, long count) {
        PriorityBlockingQueue<Stats> priorityBlockingQueue = this.pq;
        synchronized (priorityBlockingQueue) {
            int n = fIdx;
            this.frmtCount[n] = this.frmtCount[n] + count;
            Stats tmp = new Stats(fIdx, this.frmtCount[fIdx]);
            this.pq.remove(tmp);
            this.pq.offer(tmp);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("update forest " + fIdx));
        }
    }

    @Override
    public int getPlacementForestIndex(DocumentURI uri) {
        int idx = 0;
        try {
            idx = this.popAndInsert();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Statistical assignment gets interrupted");
        }
        return idx;
    }

    private class Stats
    implements Comparable<Stats> {
        int fIdx;
        long frmtCount;

        public Stats(int fIdx, long frmtCount) {
            this.fIdx = fIdx;
            this.frmtCount = frmtCount;
        }

        @Override
        public int compareTo(Stats o) {
            if (this.frmtCount > o.frmtCount) {
                return 1;
            }
            if (this.frmtCount < o.frmtCount) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            return this.fIdx == ((Stats)obj).fIdx;
        }
    }
}

