/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.tree;

import com.marklogic.dom.NodeImpl;
import com.marklogic.io.BiendianDataInputStream;
import com.marklogic.io.Decoder;
import com.marklogic.tree.Capability;
import com.marklogic.tree.ExpandedTree;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompressedTreeDecoder {
    public static final Log LOG = LogFactory.getLog(CompressedTreeDecoder.class);
    private static final Charset UTF8 = Charset.forName("UTF8");
    private static final byte[] xmlURIBytes = "http://www.w3.org/XML/1998/namespace".getBytes(UTF8);
    private static final byte[] xsiURIBytes = "http://www.w3.org/2001/XMLSchema-instance".getBytes(UTF8);
    private static final byte[] spaceBytes = "space".getBytes(UTF8);
    private static final byte[] langBytes = "lang".getBytes(UTF8);
    private static final byte[] baseBytes = "base".getBytes(UTF8);
    private static final byte[] typeBytes = "type".getBytes(UTF8);
    static final int MAX_BINARY_BYTES = 0x20000000;
    private static final int xmlSpaceAttrPresentFlag = 1;
    private static final int xmlLangAttrPresentFlag = 2;
    private static final int xmlBaseAttrPresentFlag = 4;
    private static final int xsiTypeAttrPresentFlag = 8;

    public String utf8(String s) {
        byte[] b = s.getBytes(UTF8);
        StringBuilder buf = new StringBuilder();
        for (byte value : b) {
            buf.append(String.format("%02x", value & 0xFF));
        }
        return buf.toString();
    }

    private void decodeText(ExpandedTree rep, Decoder decoder, int atomLimit) throws IOException {
        int size;
        if (atomLimit == 0) {
            return;
        }
        int numAtoms = decoder.decodeUnsigned();
        int index = rep.numTextReps;
        int minSize = rep.numTextReps + numAtoms + 1;
        if (rep.textReps == null) {
            size = Math.max(rep.atomLimit * 16, minSize);
            rep.textReps = new int[size];
        } else if (rep.textReps.length < minSize) {
            size = Math.max(rep.textReps.length * 2, minSize);
            int[] textReps = new int[size];
            System.arraycopy(rep.textReps, 0, textReps, 0, index);
            rep.textReps = textReps;
        }
        rep.textReps[index++] = numAtoms;
        rep.numTextReps += numAtoms + 1;
        for (int j = 0; j < numAtoms; ++j) {
            int atom = decoder.decodeUnsigned();
            assert (atom < atomLimit);
            rep.textReps[index++] = atom;
        }
    }

    private void addText(ExpandedTree rep, int numKeys) throws IOException {
        if (numKeys == 0) {
            return;
        }
        int index = rep.numTextReps;
        int minSize = rep.numTextReps + numKeys + 1;
        if (rep.textReps == null) {
            int size = Math.max(rep.atomLimit * 16, minSize);
            rep.textReps = new int[size];
        } else if (rep.textReps.length < minSize) {
            int size = Math.max(rep.textReps.length * 2, minSize);
            int[] textReps = new int[size];
            System.arraycopy(rep.textReps, 0, textReps, 0, index);
            rep.textReps = textReps;
        }
    }

    private int pow2ceil(int x) {
        int y;
        for (y = 8; y < x; y <<= 1) {
        }
        return y;
    }

    public ExpandedTree decode(byte[] buf, int len) throws IOException {
        int i;
        int i2;
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        BiendianDataInputStream is = new BiendianDataInputStream(bis);
        Decoder decoder = new Decoder(is);
        ExpandedTree rep = new ExpandedTree();
        rep.uriKey = decoder.decode64bits();
        rep.uniqKey = decoder.decode64bits();
        rep.linkKey = decoder.decode64bits();
        if (rep.linkKey == -1L) {
            rep.linkKey = decoder.decode64bits();
            Inflater decompresser = new Inflater();
            decompresser.setInput(buf, 32, len - 32);
            int resultLength = 0;
            int offset = 0;
            int buflen = Math.min(this.pow2ceil(len) * 2, 0x10000000);
            byte[] result = new byte[buflen];
            try {
                while (true) {
                    resultLength += decompresser.inflate(result, offset, buflen - offset);
                    if (!decompresser.finished()) {
                        offset = buflen;
                        buflen += Math.min(buflen, 0x10000000);
                        result = Arrays.copyOf(result, buflen);
                        continue;
                    }
                    break;
                }
            }
            catch (DataFormatException ex) {
                throw new IOException("zip inflate failed");
            }
            bis = new ByteArrayInputStream(result, 0, resultLength);
            is = new BiendianDataInputStream(bis);
            decoder = new Decoder(is);
        }
        rep.numKeys = decoder.decodeUnsigned();
        if (rep.numKeys == 0) {
            rep.keys = null;
        } else {
            rep.keys = new long[rep.numKeys];
            for (int i3 = 0; i3 < rep.numKeys; ++i3) {
                rep.keys[i3] = decoder.decode64bits();
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("uriKey  %016x", rep.uriKey));
            LOG.trace((Object)String.format("uniqKey %016x", rep.uniqKey));
            LOG.trace((Object)String.format("linkKey %016x", rep.linkKey));
            for (int i4 = 0; i4 < rep.numKeys; ++i4) {
                LOG.trace((Object)String.format("  key[%d] %016x", i4, rep.keys[i4]));
            }
        }
        int numAtomDataWords = decoder.decodeUnsigned();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("numAtomDataWords %d", numAtomDataWords));
        }
        if (numAtomDataWords == 0) {
            rep.atomData = null;
        } else {
            rep.atomData = new byte[numAtomDataWords * 4];
            int j = 0;
            for (i2 = 0; i2 < numAtomDataWords; ++i2) {
                int word = decoder.decode32bits();
                rep.atomData[j++] = (byte)(word & 0xFF);
                rep.atomData[j++] = (byte)(word >> 8 & 0xFF);
                rep.atomData[j++] = (byte)(word >> 16 & 0xFF);
                rep.atomData[j++] = (byte)(word >> 24 & 0xFF);
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)String.format("  atomData[%d] %08x", i2, word));
                LOG.trace((Object)String.format("  atomData[%d] %02x %02x %02x %02x", i2, rep.atomData[i2 * 4], rep.atomData[i2 * 4 + 1], rep.atomData[i2 * 4 + 2], rep.atomData[i2 * 4 + 3]));
            }
        }
        rep.atomLimit = decoder.decodeUnsigned();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("atomLimit %d", rep.atomLimit));
        }
        if (rep.atomLimit == 0) {
            rep.atomIndex = null;
        } else {
            rep.atomIndex = new int[rep.atomLimit + 1];
            int j = 0;
            for (int i5 = 0; i5 < rep.atomLimit; ++i5) {
                rep.atomIndex[i5] = j;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)String.format("  atomIndex[%d] %08x", i5, rep.atomIndex[i5]));
                }
                if (rep.atomData == null) continue;
                while (rep.atomData[j++] != 0) {
                }
            }
            rep.atomIndex[rep.atomLimit] = j;
        }
        for (i2 = 0; i2 < rep.atomLimit; ++i2) {
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)String.format("  atomString[%d] %s", i2, rep.atomString(i2)));
        }
        int numNodeNameReps = decoder.decodeUnsigned();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("numNodeNameReps %d", numNodeNameReps));
        }
        if (numNodeNameReps == 0) {
            rep.nodeNameNameAtom = null;
            rep.nodeNameNamespaceAtom = null;
        } else {
            rep.nodeNameNameAtom = new int[numNodeNameReps];
            rep.nodeNameNamespaceAtom = new int[numNodeNameReps];
        }
        int xmlSpaceNodeNameRepID = Integer.MAX_VALUE;
        int xmlLangNodeNameRepID = Integer.MAX_VALUE;
        int xmlBaseNodeNameRepID = Integer.MAX_VALUE;
        int xsiTypeNodeNameRepID = Integer.MAX_VALUE;
        for (int j = 0; j < numNodeNameReps; ++j) {
            rep.nodeNameNameAtom[j] = decoder.decodeUnsigned();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("  nodeNameNameAtom[%d] %d", j, rep.nodeNameNameAtom[j]));
            }
            assert (rep.nodeNameNameAtom[j] < rep.atomLimit);
            rep.nodeNameNamespaceAtom[j] = decoder.decodeUnsigned();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("  nodeNameNamespaceAtom[%d] %d", j, rep.nodeNameNamespaceAtom[j]));
            }
            assert (rep.nodeNameNamespaceAtom[j] < rep.atomLimit);
            if (rep.atomEquals(rep.nodeNameNamespaceAtom[j], xmlURIBytes)) {
                if (rep.atomEquals(rep.nodeNameNameAtom[j], spaceBytes)) {
                    xmlSpaceNodeNameRepID = j;
                    continue;
                }
                if (rep.atomEquals(rep.nodeNameNameAtom[j], langBytes)) {
                    xmlLangNodeNameRepID = j;
                    continue;
                }
                if (!rep.atomEquals(rep.nodeNameNameAtom[j], baseBytes)) continue;
                xmlBaseNodeNameRepID = j;
                continue;
            }
            if (!rep.atomEquals(rep.nodeNameNameAtom[j], xsiURIBytes) || !rep.atomEquals(rep.nodeNameNameAtom[j], typeBytes)) continue;
            xsiTypeNodeNameRepID = j;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("xmlSpaceNodeNameRepID %d", xmlSpaceNodeNameRepID));
            LOG.trace((Object)String.format("xmlLangNodeNameRepID %d", xmlLangNodeNameRepID));
            LOG.trace((Object)String.format("xmlBaseNodeNameRepID %d", xmlBaseNodeNameRepID));
            LOG.trace((Object)String.format("xsiTypeNodeNameRepID %d", xsiTypeNodeNameRepID));
        }
        int numElemNodeReps = 0;
        int numAttrNodeReps = 0;
        int numDocNodeReps = 0;
        int numPINodeReps = 0;
        int numArrayNodeReps = 0;
        int numDoubles = 0;
        rep.numNodeReps = decoder.decodeUnsigned();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("numNodeReps %d", rep.numNodeReps));
        }
        if (rep.numNodeReps == 0) {
            int version = decoder.decodeUnsigned();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("version %d", version));
            }
            assert (version <= 1);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("version %d", version));
            }
            if (version > 1) {
                throw new IOException("Unexpected tree version:" + version);
            }
            rep.numNodeReps = decoder.decodeUnsigned();
            if (version == 1) {
                rep.numMetadata = decoder.decodeUnsigned();
                numElemNodeReps = decoder.decodeUnsigned();
                numAttrNodeReps = decoder.decodeUnsigned();
                rep.numLinkNodeReps = decoder.decodeUnsigned() * 4 / 3;
                numPINodeReps = decoder.decodeUnsigned();
                rep.numNSNodeReps = decoder.decodeUnsigned();
            } else {
                rep.numMetadata = 0;
                numElemNodeReps = 0;
                numAttrNodeReps = 0;
                numPINodeReps = 0;
                rep.numLinkNodeReps = 0;
                rep.numNSNodeReps = 0;
            }
            numArrayNodeReps = decoder.decodeUnsigned();
            numDoubles = decoder.decodeUnsigned();
            numDocNodeReps = decoder.decodeUnsigned();
        } else {
            rep.numMetadata = 0;
            numArrayNodeReps = 0;
            numDoubles = 0;
            numElemNodeReps = decoder.decodeUnsigned();
            numAttrNodeReps = decoder.decodeUnsigned();
            rep.numLinkNodeReps = decoder.decodeUnsigned() * 4 / 3;
            numDocNodeReps = decoder.decodeUnsigned();
            numPINodeReps = decoder.decodeUnsigned();
            rep.numNSNodeReps = decoder.decodeUnsigned();
        }
        rep.numPermNodeReps = decoder.decodeUnsigned();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("rep.numNodeReps %d", rep.numNodeReps));
            LOG.trace((Object)String.format("rep.numMetadata %d", rep.numMetadata));
            LOG.trace((Object)String.format("numElemNodeReps %d", numElemNodeReps));
            LOG.trace((Object)String.format("numAttrNodeReps %d", numAttrNodeReps));
            LOG.trace((Object)String.format("rep.numLinkNodeReps %d", rep.numLinkNodeReps));
            LOG.trace((Object)String.format("numPINodeReps %d", numPINodeReps));
            LOG.trace((Object)String.format("rep.numNSNodeReps %d", rep.numNSNodeReps));
            LOG.trace((Object)String.format("rep.numArrayNodeReps %d", numArrayNodeReps));
            LOG.trace((Object)String.format("numDoubles %d", numDoubles));
            LOG.trace((Object)String.format("numDocNodeReps %d", numDocNodeReps));
            LOG.trace((Object)String.format("rep.numPermNodeReps %d", rep.numPermNodeReps));
        }
        if (rep.numNodeReps > 0) {
            rep.nodes = new NodeImpl[rep.numNodeReps];
            rep.nodeOrdinal = new long[rep.numNodeReps];
            rep.nodeKind = new byte[rep.numNodeReps];
            rep.nodeRepID = new int[rep.numNodeReps];
            rep.nodeParentNodeRepID = new int[rep.numNodeReps];
        }
        if (numArrayNodeReps > 0) {
            rep.arrayNodeTextRepID = new int[numArrayNodeReps];
            rep.arrayNodeChildNodeRepID = new int[numArrayNodeReps];
            rep.arrayNodeNumChildren = new int[numArrayNodeReps];
        }
        if (numDoubles > 0) {
            rep.doubles = new double[numDoubles];
        }
        if (numDocNodeReps > 0) {
            rep.docNodeTextRepID = new int[numDocNodeReps];
            rep.docNodeChildNodeRepID = new int[numDocNodeReps];
            rep.docNodeNumChildren = new int[numDocNodeReps];
        }
        if (numElemNodeReps > 0) {
            rep.elemNodeNodeNameRepID = new int[numElemNodeReps];
            rep.elemNodeAttrNodeRepID = new int[numElemNodeReps];
            rep.elemNodeChildNodeRepID = new int[numElemNodeReps];
            rep.elemNodeElemDeclRepID = new int[numElemNodeReps];
            rep.elemNodeNumAttributes = new int[numElemNodeReps];
            rep.elemNodeNumDefaultAttrs = new int[numElemNodeReps];
            rep.elemNodeNumChildren = new int[numElemNodeReps];
            rep.elemNodeFlags = new int[numElemNodeReps];
        }
        if (numAttrNodeReps > 0) {
            rep.attrNodeNodeNameRepID = new int[numAttrNodeReps];
            rep.attrNodeTextRepID = new int[numAttrNodeReps];
            rep.attrNodeAttrDeclRepID = new int[numAttrNodeReps];
        }
        if (rep.numLinkNodeReps > 0) {
            rep.linkNodeKey = new long[rep.numLinkNodeReps];
            rep.linkNodeNodeCount = new long[rep.numLinkNodeReps];
            rep.linkNodeNodeNameRepID = new int[rep.numLinkNodeReps];
            rep.linkNodeNodeRepID = new int[rep.numLinkNodeReps];
        }
        if (numDocNodeReps > 0) {
            rep.docNodeTextRepID = new int[numDocNodeReps];
            rep.docNodeChildNodeRepID = new int[numDocNodeReps];
            rep.docNodeNumChildren = new int[numDocNodeReps];
        }
        if (numPINodeReps > 0) {
            rep.piNodeTargetAtom = new int[numPINodeReps];
            rep.piNodeTextRepID = new int[numPINodeReps];
        }
        if (rep.numNSNodeReps > 0) {
            rep.nsNodeOrdinal = new long[rep.numNSNodeReps];
            rep.nsNodePrevNSNodeRepID = new int[rep.numNSNodeReps];
            rep.nsNodePrefixAtom = new int[rep.numNSNodeReps];
            rep.nsNodeUriAtom = new int[rep.numNSNodeReps];
        }
        if (rep.numPermNodeReps > 0) {
            rep.permNodeOrdinal = new long[rep.numPermNodeReps];
            rep.permNodePrevPermNodeRepID = new int[rep.numPermNodeReps];
            rep.permNodeCapability = new Capability[rep.numPermNodeReps];
            rep.permNodeRoleId = new long[rep.numPermNodeReps];
        }
        rep.uriTextRepID = 0;
        this.decodeText(rep, decoder, rep.atomLimit);
        rep.colsTextRepID = rep.numTextReps;
        this.decodeText(rep, decoder, rep.atomLimit);
        rep.metaKeys = new int[rep.numMetadata];
        rep.metaVals = new int[rep.numMetadata];
        for (i = 0; i < rep.numMetadata; ++i) {
            rep.metaKeys[i] = decoder.decodeUnsigned();
        }
        for (i = 0; i < rep.numMetadata; ++i) {
            rep.metaVals[i] = rep.numTextReps;
            this.decodeText(rep, decoder, rep.atomLimit);
        }
        int nextDocNodeRep = 0;
        int nextElemNodeRep = 0;
        int nextAttrNodeRep = 0;
        int nextPINodeRep = 0;
        int nextNSNodeRep = 0;
        int nextPermNodeRep = 0;
        int parentNodeRepID = 0;
        int nextArrayNodeRep = 0;
        int nextDouble = 0;
        long lastNSNodeRepOrdinal = 0L;
        long lastPermNodeRepOrdinal = 0L;
        block40: for (int i6 = 0; i6 < rep.numNodeReps; ++i6) {
            rep.nodeKind[i6] = (byte)decoder.decodeUnsigned(4);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("  nodeKind[%d] %s", i6, rep.nodeKind[i6]));
            }
            parentNodeRepID += decoder.decodeUnsigned();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)String.format("  parentNodeRepID[%d] %d", i6, parentNodeRepID));
            }
            assert (parentNodeRepID <= i6);
            if (parentNodeRepID == i6) {
                rep.nodeParentNodeRepID[i6] = Integer.MAX_VALUE;
            } else {
                rep.nodeParentNodeRepID[i6] = parentNodeRepID;
                assert (rep.nodeKind[parentNodeRepID] == 0 || rep.nodeKind[parentNodeRepID] == 5 || rep.nodeKind[parentNodeRepID] == 13 || rep.nodeKind[parentNodeRepID] == 14 || rep.nodeKind[parentNodeRepID] == 3);
                int parentRepID = rep.nodeRepID[parentNodeRepID];
                block1 : switch (rep.nodeKind[parentNodeRepID]) {
                    case 0: {
                        switch (rep.nodeKind[i6]) {
                            case 1: {
                                if (rep.elemNodeAttrNodeRepID[parentRepID] == Integer.MAX_VALUE) {
                                    rep.elemNodeAttrNodeRepID[parentRepID] = i6;
                                }
                                assert (rep.elemNodeAttrNodeRepID[parentRepID] + rep.elemNodeNumAttributes[parentRepID] == i6);
                                int n = parentRepID;
                                rep.elemNodeNumAttributes[n] = rep.elemNodeNumAttributes[n] + 1;
                                break block1;
                            }
                        }
                        if (rep.elemNodeChildNodeRepID[parentRepID] == Integer.MAX_VALUE) {
                            rep.elemNodeChildNodeRepID[parentRepID] = i6;
                        }
                        assert (rep.elemNodeChildNodeRepID[parentRepID] + rep.elemNodeNumChildren[parentRepID] == i6);
                        int n = parentRepID;
                        rep.elemNodeNumChildren[n] = rep.elemNodeNumChildren[n] + 1;
                        break;
                    }
                    case 5: {
                        if (rep.docNodeChildNodeRepID[parentNodeRepID] == Integer.MAX_VALUE) {
                            rep.docNodeChildNodeRepID[parentNodeRepID] = i6;
                        }
                        assert (rep.docNodeChildNodeRepID[parentNodeRepID] + rep.docNodeNumChildren[parentNodeRepID] == i6);
                        int n = parentNodeRepID;
                        rep.docNodeNumChildren[n] = rep.docNodeNumChildren[n] + 1;
                        break;
                    }
                    case 13: 
                    case 14: {
                        if (rep.arrayNodeChildNodeRepID[parentRepID] == Integer.MAX_VALUE) {
                            rep.arrayNodeChildNodeRepID[parentRepID] = i6;
                        }
                        assert (rep.arrayNodeChildNodeRepID[parentRepID] + rep.arrayNodeNumChildren[parentRepID] == i6);
                        int n = parentRepID;
                        rep.arrayNodeNumChildren[n] = rep.arrayNodeNumChildren[n] + 1;
                        break;
                    }
                }
            }
            switch (rep.nodeKind[i6]) {
                case 0: {
                    int j;
                    rep.nodeRepID[i6] = j = nextElemNodeRep++;
                    assert (j < numElemNodeReps);
                    rep.elemNodeNodeNameRepID[j] = decoder.decodeUnsigned();
                    rep.elemNodeAttrNodeRepID[j] = Integer.MAX_VALUE;
                    rep.elemNodeChildNodeRepID[j] = Integer.MAX_VALUE;
                    rep.elemNodeElemDeclRepID[j] = Integer.MAX_VALUE;
                    rep.elemNodeNumAttributes[j] = 0;
                    rep.elemNodeNumDefaultAttrs[j] = 0;
                    rep.elemNodeNumChildren[j] = 0;
                    rep.elemNodeFlags[j] = 0;
                    if (rep.elemNodeNodeNameRepID[j] < numNodeNameReps) continue block40;
                    rep.elemNodeNumDefaultAttrs[j] = rep.elemNodeNodeNameRepID[j] / numNodeNameReps;
                    rep.elemNodeNodeNameRepID[j] = rep.elemNodeNodeNameRepID[j] % numNodeNameReps;
                    continue block40;
                }
                case 1: {
                    assert (parentNodeRepID < i6);
                    assert (rep.nodeKind[parentNodeRepID] == 0);
                    rep.nodeRepID[i6] = nextAttrNodeRep++;
                    assert (rep.nodeRepID[i6] < numAttrNodeReps);
                    rep.attrNodeNodeNameRepID[rep.nodeRepID[i6]] = decoder.decodeUnsigned();
                    assert (rep.attrNodeNodeNameRepID[rep.nodeRepID[i6]] < numNodeNameReps);
                    if (rep.attrNodeNodeNameRepID[rep.nodeRepID[i6]] == xmlSpaceNodeNameRepID) {
                        int n = rep.nodeRepID[parentNodeRepID];
                        rep.elemNodeFlags[n] = rep.elemNodeFlags[n] | 1;
                    } else if (rep.attrNodeNodeNameRepID[rep.nodeRepID[i6]] == xmlLangNodeNameRepID) {
                        int n = rep.nodeRepID[parentNodeRepID];
                        rep.elemNodeFlags[n] = rep.elemNodeFlags[n] | 2;
                    } else if (rep.attrNodeNodeNameRepID[rep.nodeRepID[i6]] == xmlBaseNodeNameRepID) {
                        int n = rep.nodeRepID[parentNodeRepID];
                        rep.elemNodeFlags[n] = rep.elemNodeFlags[n] | 4;
                    } else if (rep.attrNodeNodeNameRepID[rep.nodeRepID[i6]] == xsiTypeNodeNameRepID) {
                        int n = rep.nodeRepID[parentNodeRepID];
                        rep.elemNodeFlags[n] = rep.elemNodeFlags[n] | 8;
                    }
                    rep.attrNodeTextRepID[rep.nodeRepID[i6]] = rep.numTextReps;
                    this.decodeText(rep, decoder, rep.atomLimit);
                    rep.attrNodeAttrDeclRepID[rep.nodeRepID[i6]] = Integer.MAX_VALUE;
                    continue block40;
                }
                case 2: {
                    rep.nodeRepID[i6] = rep.numTextReps;
                    this.decodeText(rep, decoder, rep.atomLimit);
                    continue block40;
                }
                case 9: {
                    rep.nodeRepID[i6] = 0;
                    int nbytes = decoder.decodeUnsigned();
                    if (nbytes > 0x20000000) {
                        rep.binaryKey = decoder.decode64bits();
                        rep.binaryOffset = decoder.decodeUnsignedLong();
                        rep.binarySize = decoder.decodeUnsignedLong();
                        rep.binaryOrigLen = decoder.decodeUnsignedLong();
                        rep.binaryPathAtom = decoder.decodeUnsigned();
                        continue block40;
                    }
                    this.decodeBinary(decoder, rep, nbytes);
                    continue block40;
                }
                case 6: {
                    rep.nodeRepID[i6] = nextPINodeRep++;
                    int piNodeRep = rep.nodeRepID[i6];
                    assert (piNodeRep < numPINodeReps);
                    int targetAtom = rep.piNodeTargetAtom[piNodeRep] = decoder.decodeUnsigned();
                    assert (targetAtom < rep.atomLimit);
                    rep.piNodeTextRepID[piNodeRep] = rep.numTextReps;
                    this.decodeText(rep, decoder, rep.atomLimit);
                    continue block40;
                }
                case 3: {
                    long key = decoder.decode64bits();
                    int linkNodeRep = (int)CompressedTreeDecoder.remainderUnsigned(key, rep.numLinkNodeReps);
                    while (true) {
                        if (rep.linkNodeKey[linkNodeRep] == 0L) {
                            rep.nodeRepID[i6] = linkNodeRep;
                            rep.linkNodeKey[linkNodeRep] = key;
                            rep.linkNodeNodeCount[linkNodeRep] = decoder.decodeUnsignedLong();
                            rep.linkNodeNodeNameRepID[linkNodeRep] = decoder.decodeUnsigned();
                            assert (rep.linkNodeNodeNameRepID[linkNodeRep] < numNodeNameReps);
                            rep.linkNodeNodeRepID[linkNodeRep] = i6;
                            continue block40;
                        }
                        linkNodeRep = CompressedTreeDecoder.hashWrap(linkNodeRep + 1, rep.numLinkNodeReps);
                    }
                }
                case 7: {
                    rep.nodeRepID[i6] = rep.numTextReps;
                    this.decodeText(rep, decoder, rep.atomLimit);
                    continue block40;
                }
                case 5: {
                    rep.nodeRepID[i6] = nextDocNodeRep++;
                    int docNode = rep.nodeRepID[i6];
                    assert (docNode < numDocNodeReps);
                    rep.docNodeTextRepID[i6] = rep.numTextReps;
                    this.decodeText(rep, decoder, rep.atomLimit);
                    rep.docNodeChildNodeRepID[docNode] = Integer.MAX_VALUE;
                    rep.docNodeNumChildren[docNode] = 0;
                    continue block40;
                }
                case 4: {
                    rep.nodeRepID[i6] = nextNSNodeRep++;
                    int nsNode = rep.nodeRepID[i6];
                    assert (nsNode < rep.numNSNodeReps);
                    lastNSNodeRepOrdinal = rep.nsNodeOrdinal[nsNode] = lastNSNodeRepOrdinal + decoder.decodeUnsignedLong();
                    rep.nsNodePrevNSNodeRepID[nsNode] = rep.nodeRepID[i6] - decoder.decodeUnsigned() - 1;
                    assert (rep.nsNodePrevNSNodeRepID[nsNode] < rep.numNSNodeReps || rep.nsNodePrevNSNodeRepID[nsNode] == Integer.MAX_VALUE);
                    rep.nsNodePrefixAtom[nsNode] = decoder.decodeUnsigned() - 1;
                    assert (rep.nsNodePrefixAtom[nsNode] < rep.atomLimit || rep.nsNodePrefixAtom[nsNode] == Integer.MAX_VALUE);
                    rep.nsNodeUriAtom[nsNode] = decoder.decodeUnsigned() - 1;
                    assert (rep.nsNodeUriAtom[nsNode] < rep.atomLimit || rep.nsNodeUriAtom[nsNode] == Integer.MAX_VALUE);
                    continue block40;
                }
                case 8: {
                    rep.nodeRepID[i6] = nextPermNodeRep++;
                    int permNode = rep.nodeRepID[i6];
                    assert (permNode < rep.numPermNodeReps);
                    lastPermNodeRepOrdinal = rep.permNodeOrdinal[permNode] = lastPermNodeRepOrdinal + decoder.decodeUnsignedLong();
                    rep.permNodePrevPermNodeRepID[permNode] = permNode - decoder.decodeUnsigned() - 1;
                    long prevPermNode = rep.permNodePrevPermNodeRepID[permNode];
                    assert (prevPermNode < (long)rep.numPermNodeReps || prevPermNode == Integer.MAX_VALUE);
                    Capability capability = rep.permNodeCapability[permNode] = Capability.values()[decoder.decodeUnsigned(4)];
                    assert (capability != Capability.NULL);
                    long roleId = rep.permNodeRoleId[permNode] = decoder.decode64bits();
                    assert (roleId < Long.MAX_VALUE);
                    continue block40;
                }
                case 10: {
                    switch (decoder.decodeUnsigned(3)) {
                        case 1: {
                            rep.nodeKind[i6] = 11;
                            rep.nodeRepID[i6] = 0;
                            break;
                        }
                        case 2: {
                            rep.nodeKind[i6] = 11;
                            rep.nodeRepID[i6] = 1;
                            break;
                        }
                        case 3: {
                            rep.nodeKind[i6] = 12;
                            rep.nodeRepID[i6] = nextDouble++;
                            assert (rep.nodeRepID[i6] < numDoubles);
                            rep.doubles[rep.nodeRepID[i6]] = decoder.decodeDouble();
                            break;
                        }
                        case 4: {
                            rep.nodeKind[i6] = 13;
                            rep.nodeRepID[i6] = nextArrayNodeRep++;
                            assert (rep.nodeRepID[i6] < numArrayNodeReps);
                            rep.arrayNodeTextRepID[rep.nodeRepID[i6]] = Integer.MAX_VALUE;
                            rep.arrayNodeChildNodeRepID[rep.nodeRepID[i6]] = Integer.MAX_VALUE;
                            rep.arrayNodeNumChildren[rep.nodeRepID[i6]] = 0;
                            break;
                        }
                        case 5: {
                            rep.nodeKind[i6] = 14;
                            rep.nodeRepID[i6] = nextArrayNodeRep++;
                            assert (rep.nodeRepID[i6] < numArrayNodeReps);
                            rep.arrayNodeTextRepID[rep.nodeRepID[i6]] = rep.numTextReps;
                            rep.arrayNodeChildNodeRepID[rep.nodeRepID[i6]] = Integer.MAX_VALUE;
                            rep.arrayNodeNumChildren[rep.nodeRepID[i6]] = 0;
                            int numKeys = decoder.decodeUnsigned();
                            this.addText(rep, numKeys);
                            int atomLimit = rep.atomLimit;
                            for (int j = 0; j < numKeys; ++j) {
                                int atom = decoder.decodeUnsigned();
                                assert (atom < atomLimit);
                                if (atom >= atomLimit) {
                                    String bad = "atom";
                                    if (LOG.isTraceEnabled()) {
                                        LOG.trace((Object)String.format("bad atom %d atomLimit %d", atom, atomLimit));
                                    }
                                }
                                rep.textReps[rep.numTextReps++] = atom;
                            }
                            continue block40;
                        }
                    }
                    continue block40;
                }
            }
        }
        if (rep.numNodeReps > 0) {
            this.assignOrdinals(rep);
        }
        return rep;
    }

    static long remainderUnsigned(long dividend, int divisor) {
        if (dividend > 0L && divisor > 0) {
            return dividend % (long)divisor;
        }
        if (Long.compare(dividend + Long.MIN_VALUE, (long)divisor + Long.MIN_VALUE) < 0) {
            return dividend;
        }
        return CompressedTreeDecoder.toUnsignedBigInteger(dividend).remainder(CompressedTreeDecoder.toUnsignedBigInteger(divisor)).longValue();
    }

    static BigInteger toUnsignedBigInteger(long i) {
        if (i >= 0L) {
            return BigInteger.valueOf(i);
        }
        int upper = (int)(i >>> 32);
        int lower = (int)i;
        return BigInteger.valueOf((long)upper & 0xFFFFFFFFL).shiftLeft(32).add(BigInteger.valueOf((long)lower & 0xFFFFFFFFL));
    }

    private void decodeBinary(Decoder decoder, ExpandedTree rep, int nbytes) throws IOException {
        int nwords = (nbytes + 3) / 4;
        if (nwords <= 0) {
            LOG.error((Object)("nbytes=" + nbytes + ", nwords=" + nwords));
        }
        rep.binaryData = new int[nwords];
        decoder.decode(rep.binaryData, nwords);
    }

    private void assignOrdinals(ExpandedTree rep) {
        long ordinal = 0L;
        int nodeID = 0;
        if (rep.nodeKind[0] == 3) {
            rep.ordinal = rep.linkNodeNodeCount[rep.nodeRepID[0]];
            rep.nodeOrdinal[0] = 0L;
            nodeID = 1;
        }
        block6: while (nodeID != Integer.MAX_VALUE) {
            ++ordinal;
            switch (rep.nodeKind[nodeID]) {
                case 0: {
                    int elemID = rep.nodeRepID[nodeID];
                    for (int i = 0; i < rep.elemNodeNumAttributes[elemID]; ++i) {
                        int attrNodeID = rep.elemNodeAttrNodeRepID[elemID] + i;
                        ++ordinal;
                    }
                    int childNodeID = rep.elemNodeChildNodeRepID[elemID];
                    if (childNodeID == Integer.MAX_VALUE) break;
                    nodeID = childNodeID;
                    continue block6;
                }
                case 3: {
                    int linkID = rep.nodeRepID[nodeID];
                    ordinal += rep.linkNodeNodeCount[linkID] - 1L;
                    break;
                }
                case 5: {
                    int docID = rep.nodeRepID[nodeID];
                    int childNodeID = rep.docNodeChildNodeRepID[docID];
                    if (childNodeID == Integer.MAX_VALUE) break;
                    nodeID = childNodeID;
                    continue block6;
                }
                case 13: 
                case 14: {
                    int docID = rep.nodeRepID[nodeID];
                    int childNodeID = rep.arrayNodeChildNodeRepID[docID];
                    if (childNodeID == Integer.MAX_VALUE) break;
                    nodeID = childNodeID;
                    continue block6;
                }
            }
            int parentNodeID = rep.nodeParentNodeRepID[nodeID];
            while (true) {
                int docID;
                int elemID;
                if (parentNodeID == Integer.MAX_VALUE) {
                    nodeID = Integer.MAX_VALUE;
                    continue block6;
                }
                if (rep.nodeKind[parentNodeID] == 0 ? ++nodeID < rep.elemNodeChildNodeRepID[elemID = rep.nodeRepID[parentNodeID]] + rep.elemNodeNumChildren[elemID] : (rep.nodeKind[parentNodeID] == 5 ? ++nodeID < rep.docNodeChildNodeRepID[docID = rep.nodeRepID[parentNodeID]] + rep.docNodeNumChildren[docID] : (rep.nodeKind[parentNodeID] == 13 || rep.nodeKind[parentNodeID] == 14) && ++nodeID < rep.arrayNodeChildNodeRepID[docID = rep.nodeRepID[parentNodeID]] + rep.arrayNodeNumChildren[docID])) continue block6;
                nodeID = parentNodeID;
                parentNodeID = rep.nodeParentNodeRepID[nodeID];
            }
        }
        for (int j = rep.numNodeReps - rep.numNSNodeReps - rep.numPermNodeReps; j < rep.numNodeReps; ++j) {
            ++ordinal;
        }
        for (int k = rep.numNodeReps - rep.numPermNodeReps; k < rep.numNodeReps; ++k) {
            ++ordinal;
        }
        if (Boolean.getBoolean("xcc.decode.atoms")) {
            for (int x = 0; x < rep.atomLimit; ++x) {
                rep.atomString(x);
            }
        }
    }

    public static int hashWrap(int x, int y) {
        return x < y ? x : x - y;
    }
}

