/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.exceptions;

import com.marklogic.xcc.Request;
import com.marklogic.xcc.exceptions.QueryStackFrame;
import com.marklogic.xcc.exceptions.RequestServerException;
import com.marklogic.xcc.types.XdmVariable;

public abstract class QueryException
extends RequestServerException {
    private static final long serialVersionUID = 2424928147667627804L;
    final String code;
    final String w3cCode;
    final String formatString;
    final String expr;
    final String[] data;
    final transient QueryStackFrame[] stack;

    public QueryException(Request request, String code, String w3cCode, String message, String formatString, String expr, boolean isRetryable, String[] data, QueryStackFrame[] stack) {
        super(message == null || message.length() == 0 ? code : message, request, isRetryable);
        this.code = code;
        this.w3cCode = w3cCode;
        this.formatString = formatString;
        this.expr = expr;
        this.data = (String[])data.clone();
        this.stack = (QueryStackFrame[])stack.clone();
    }

    public String getCode() {
        return this.code;
    }

    public String getW3CCode() {
        return this.w3cCode;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public String[] getData() {
        return (String[])this.data.clone();
    }

    public QueryStackFrame[] getStack() {
        return (QueryStackFrame[])this.stack.clone();
    }

    @Override
    public String toString() {
        int i;
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(": ");
        if (this.formatString != null && !this.formatString.equals("")) {
            sb.append(this.formatString);
        } else {
            sb.append(this.code);
            for (i = 0; i < this.data.length; ++i) {
                sb.append(" ");
                sb.append(this.data[i]);
            }
        }
        this.appendRequestInfo(sb);
        if (this.stack != null) {
            for (i = 0; i < this.stack.length; ++i) {
                int contextPosition;
                XdmVariable[] variables;
                String operation;
                int line;
                QueryStackFrame frame = this.stack[i];
                boolean b = false;
                String uri = frame.getUri();
                if (uri != null && uri.length() > 0) {
                    b = true;
                    sb.append(nl);
                    sb.append("in ");
                    sb.append(uri);
                }
                if ((line = frame.getLineNumber()) != 0) {
                    if (b) {
                        sb.append(", ");
                    } else {
                        sb.append(nl);
                        b = true;
                    }
                    sb.append("on line ");
                    sb.append(line);
                }
                if (this.expr != null && this.expr.length() != 0) {
                    sb.append(nl);
                    sb.append("expr: ");
                    sb.append(this.expr);
                }
                if ((operation = frame.getOperation()) != null && operation.length() > 0) {
                    if (b) {
                        sb.append(',');
                    } else {
                        b = true;
                    }
                    sb.append(nl);
                    sb.append("in ");
                    sb.append(operation);
                }
                if ((variables = frame.getVariables()) == null) continue;
                for (int j = 0; j < variables.length; ++j) {
                    XdmVariable variable = variables[j];
                    String name = variable.getName().getLocalname();
                    String value = variable.getValue().asString();
                    if (name == null || name.length() <= 0 || value == null || value.length() <= 0) continue;
                    sb.append(nl);
                    sb.append("  $");
                    sb.append(name);
                    sb.append(" = ");
                    sb.append(value);
                }
                String contextItem = frame.getContextItem();
                if (contextItem != null && contextItem.length() > 0) {
                    sb.append(nl);
                    sb.append("  context-item() = ");
                    sb.append(contextItem);
                }
                if ((contextPosition = frame.getContextPosition()) == 0) continue;
                sb.append(nl);
                sb.append("  context-position() = ");
                sb.append(contextPosition);
            }
        }
        return sb.toString();
    }
}

