/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.xcc.ContentbaseMetaData;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.Session;
import com.marklogic.xcc.Version;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.types.XSDecimal;
import com.marklogic.xcc.types.XSInteger;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class CBMetaDataImpl
implements ContentbaseMetaData {
    private static final long REFRESH_DELTA_MILLIS = 60000L;
    private Session session;
    private final Request serverVersionRequest;
    private final Request contentBaseNameRequest;
    private final Request forestMapRequest;
    private String serverVersionString = null;
    private int serverMajorVersion = 0;
    private int serverMinorVersion = 0;
    private int serverPatchVersion = 0;
    private BigInteger contentbaseId = null;
    private String contentBaseName = null;
    private Map<String, BigInteger> forestMap = null;
    private long lastServerVersionCheck = 0L;
    private long lastContentBaseNameCheck = 0L;
    private long lastForestMapCheck = 0L;

    CBMetaDataImpl(Session session) {
        this.session = session;
        this.serverVersionRequest = session.newAdhocQuery("xdmp:version()");
        this.contentBaseNameRequest = session.newAdhocQuery("(xdmp:database(), xdmp:database-name (xdmp:database()))");
        this.forestMapRequest = session.newAdhocQuery("for $id in xdmp:database-forests (xdmp:database())return (xdmp:forest-name ($id), $id)");
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public String getUser() {
        return this.session.getUserCredentials().getUserName();
    }

    @Override
    public String getContentBaseName() throws RequestException {
        this.refreshContentBaseIdentity();
        return this.contentBaseName;
    }

    @Override
    public BigInteger getContentBaseId() throws RequestException {
        this.refreshContentBaseIdentity();
        return this.contentbaseId;
    }

    @Override
    public BigInteger[] getForestIds() throws RequestException {
        this.refreshForestMap();
        Collection<BigInteger> values = this.forestMap.values();
        BigInteger[] ids = new BigInteger[values.size()];
        values.toArray(ids);
        return ids;
    }

    @Override
    public String[] getForestNames() throws RequestException {
        this.refreshForestMap();
        Set<String> keys = this.forestMap.keySet();
        String[] names = new String[keys.size()];
        keys.toArray(names);
        return names;
    }

    @Override
    public Map<String, BigInteger> getForestMap() throws RequestException {
        this.refreshForestMap();
        return this.forestMap;
    }

    @Override
    public String getDriverVersionString() {
        return Version.getVersionString();
    }

    @Override
    public int getDriverMajorVersion() {
        return Version.getVersionMajor();
    }

    @Override
    public int getDriverMinorVersion() {
        return Version.getVersionMinor();
    }

    @Override
    public int getDriverPatchVersion() {
        return Version.getVersionPatch();
    }

    @Override
    public String getServerVersionString() throws RequestException {
        this.refreshServerVersion();
        return this.serverVersionString;
    }

    @Override
    public int getServerMajorVersion() throws RequestException {
        this.refreshServerVersion();
        return this.serverMajorVersion;
    }

    @Override
    public int getServerMinorVersion() throws RequestException {
        this.refreshServerVersion();
        return this.serverMinorVersion;
    }

    @Override
    public int getServerPatchVersion() throws RequestException {
        this.refreshServerVersion();
        return this.serverPatchVersion;
    }

    private void refreshServerVersion() throws RequestException {
        if (this.stillFresh(this.lastServerVersionCheck)) {
            return;
        }
        this.lastServerVersionCheck = System.currentTimeMillis();
        try (ResultSequence rs = null;){
            rs = this.session.submitRequest(this.serverVersionRequest);
            this.serverVersionString = rs.asString();
            String[] subs = this.serverVersionString.split("\\.|-|_");
            if (subs.length < 3) {
                throw new RequestException("Malformed server version string: " + this.serverVersionString, this.serverVersionRequest);
            }
            this.serverMajorVersion = Integer.parseInt(subs[0]);
            this.serverMinorVersion = Integer.parseInt(subs[1]);
            this.serverPatchVersion = Integer.parseInt(subs[2]);
        }
    }

    private void refreshContentBaseIdentity() throws RequestException {
        if (this.stillFresh(this.lastContentBaseNameCheck)) {
            return;
        }
        this.lastContentBaseNameCheck = System.currentTimeMillis();
        try (ResultSequence rs = null;){
            rs = this.session.submitRequest(this.contentBaseNameRequest);
            this.contentbaseId = rs.itemAt(0) instanceof XSDecimal ? ((XSDecimal)rs.itemAt(0)).asBigDecimal().toBigInteger() : ((XSInteger)rs.itemAt(0)).asBigInteger();
            this.contentBaseName = rs.itemAt(1).asString();
        }
    }

    private void refreshForestMap() throws RequestException {
        if (this.stillFresh(this.lastForestMapCheck)) {
            return;
        }
        this.lastForestMapCheck = System.currentTimeMillis();
        ResultSequence rs = this.session.submitRequest(this.forestMapRequest);
        String[] values = rs.asStrings();
        HashMap<String, BigInteger> map = new HashMap<String, BigInteger>();
        for (int i = 0; i < values.length; i += 2) {
            map.put(values[i], new BigInteger(values[i + 1]));
        }
        this.forestMap = Collections.unmodifiableMap(map);
    }

    private boolean stillFresh(long timestamp) {
        long now = System.currentTimeMillis();
        return now - timestamp < 60000L;
    }
}

