/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl;

import com.marklogic.io.Base64;
import com.marklogic.io.IOHelper;
import com.marklogic.xcc.UserCredentials;
import com.marklogic.xcc.impl.PDCloudAuthManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

public class Credentials
implements UserCredentials {
    private static Random random = new Random();
    private static final String DEFAULT_TOKEN_ENDPOINT = "/token";
    private static final String DEFAULT_GRANT_TYPE = "apikey";
    public static final int DEFAULT_TOKEN_DURATION = 60;
    private String user;
    private char[] password;
    private String basicAuth;
    private String HA1;
    private LoginContext loginContext;
    private PDCloudAuthConfig pdCloudAuthConfig;
    private char[] OAuthToken;
    private static final AtomicLong nonceCounter = new AtomicLong();

    public Credentials(char[] OAuthToken) {
        this.OAuthToken = OAuthToken;
    }

    public Credentials(String user, char[] password) {
        this.user = user;
        this.password = password;
        if (user != null && password != null) {
            this.initBasicAuth();
        }
    }

    public Credentials(char[] apiKey, String tokenEndpoint, String grantType, int tokenDuration) {
        this.pdCloudAuthConfig = new PDCloudAuthConfig(apiKey, tokenEndpoint, grantType, tokenDuration);
    }

    public Credentials() {
    }

    @Override
    public String getUserName() {
        return this.user;
    }

    @Override
    public PDCloudAuthConfig getPDCloudAuthConfig() {
        return this.pdCloudAuthConfig;
    }

    public char[] getOAuthToken() {
        return this.OAuthToken;
    }

    void initBasicAuth(Charset encoding) throws UnsupportedEncodingException {
        byte[] ubytes = (this.user + ":").getBytes(encoding);
        ByteBuffer pbuf = encoding.encode(CharBuffer.wrap(this.password));
        byte[] upbytes = new byte[pbuf.remaining() + ubytes.length];
        System.arraycopy(ubytes, 0, upbytes, 0, ubytes.length);
        pbuf.get(upbytes, ubytes.length, pbuf.remaining());
        this.basicAuth = "basic " + Base64.encodeBytes(upbytes, 8);
    }

    void initBasicAuth() {
        try {
            this.initBasicAuth(StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            try {
                this.initBasicAuth(Charset.defaultCharset());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    @Override
    public String toHttpBasicAuth() {
        if (this.user == null || this.password == null && this.basicAuth == null) {
            throw new IllegalStateException("Invalid authentication credentials");
        }
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
            this.password = null;
        }
        return this.basicAuth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toHttpDigestAuth(String method, String uri, String challengeHeader) {
        if (this.user == null || this.password == null && this.HA1 == null) {
            throw new IllegalStateException("Invalid authentication credentials");
        }
        if (challengeHeader == null || !challengeHeader.startsWith("Digest ")) {
            return null;
        }
        String[] pairs = challengeHeader.substring("Digest ".length()).split(", +");
        HashMap<String, String> params = new HashMap<String, String>();
        for (String pair : pairs) {
            String[] nv = pair.split("=", 2);
            params.put(nv[0].toLowerCase(), nv[1].substring(1, nv[1].length() - 1));
        }
        String realm = (String)params.get("realm");
        if (this.HA1 == null) {
            this.HA1 = Credentials.digestCalcHA1(this.user, realm, this.password);
        }
        String nonce = (String)params.get("nonce");
        String qop = (String)params.get("qop");
        String opaque = (String)params.get("opaque");
        byte[] bytes = new byte[16];
        Random random = Credentials.random;
        synchronized (random) {
            Credentials.random.nextBytes(bytes);
        }
        String cNonce = IOHelper.bytesToHex(bytes);
        String nonceCount = Long.toHexString(nonceCounter.incrementAndGet());
        String response = Credentials.digestCalcResponse(this.HA1, nonce, nonceCount, cNonce, qop, method, uri);
        StringBuilder buf = new StringBuilder();
        buf.append("Digest username=\"");
        buf.append(this.user);
        buf.append("\", realm=\"");
        buf.append(realm);
        buf.append("\", nonce=\"");
        buf.append(nonce);
        buf.append("\", uri=\"");
        buf.append(uri);
        buf.append("\", qop=\"auth\", nc=\"");
        buf.append(nonceCount);
        buf.append("\", cnonce=\"");
        buf.append(cNonce);
        buf.append("\", response=\"");
        buf.append(response);
        buf.append("\", opaque=\"");
        buf.append(opaque);
        buf.append("\"");
        return buf.toString();
    }

    @Override
    public String toHttpNegotiateAuth(String hostName, String challenge) {
        try {
            if (this.loginContext == null) {
                this.buildSubjectCredentials();
            }
            return "Negotiate " + this.getAuthorizationHeader("HTTP/" + hostName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toMLCloudAuth() {
        return "Bearer " + PDCloudAuthManager.getSessionToken(this.getPDCloudAuthConfig().getApiKey());
    }

    @Override
    public String toOAuth() {
        return "Bearer " + new String(this.OAuthToken);
    }

    public String toString() {
        return "user=" + this.user;
    }

    public static String digestCalcResponse(String HA1, String nonce, String nonceCount, String cNonce, String qop, String method, String uri) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            StringBuilder plaintext = new StringBuilder();
            plaintext.append(method);
            plaintext.append(":");
            plaintext.append(uri);
            digest.update(plaintext.toString().getBytes(), 0, plaintext.length());
            String HA2 = IOHelper.bytesToHex(digest.digest());
            plaintext.setLength(0);
            plaintext.append(HA1);
            plaintext.append(":");
            plaintext.append(nonce);
            plaintext.append(":");
            if (qop != null) {
                plaintext.append(nonceCount);
                plaintext.append(":");
                plaintext.append(cNonce);
                plaintext.append(":");
                plaintext.append(qop);
                plaintext.append(":");
            }
            plaintext.append(HA2);
            digest.update(plaintext.toString().getBytes(), 0, plaintext.length());
            return IOHelper.bytesToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String digestCalcHA1(String userName, String realm, char[] password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            StringBuilder plaintext = new StringBuilder();
            plaintext.append(userName);
            plaintext.append(":");
            plaintext.append(realm);
            plaintext.append(":");
            byte[] ubytes = plaintext.toString().getBytes();
            ByteBuffer pbuf = Charset.defaultCharset().encode(CharBuffer.wrap(password));
            byte[] upbytes = new byte[pbuf.remaining() + ubytes.length];
            System.arraycopy(ubytes, 0, upbytes, 0, ubytes.length);
            pbuf.get(upbytes, ubytes.length, pbuf.remaining());
            digest.update(upbytes, 0, upbytes.length);
            return IOHelper.bytesToHex(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private void buildSubjectCredentials() throws KrbException, IOException, LoginException {
        Subject subject = new Subject();
        sun.security.krb5.Credentials cred = this.user != null && !this.user.equals("") ? sun.security.krb5.Credentials.acquireTGTFromCache(new PrincipalName(this.user), null) : sun.security.krb5.Credentials.acquireTGTFromCache(null, null);
        if (cred == null) {
            throw new KrbException("No ticket granting ticket in the cache");
        }
        Date endTime = cred.getEndTime();
        if (endTime != null && endTime.compareTo(new Date()) == -1) {
            throw new KrbException("The ticket granting ticket in the cache is no longer valid");
        }
        this.loginContext = new LoginContext("Krb5LoginContext", subject, null, new KerberosLoginConfiguration());
        this.loginContext.login();
    }

    private String getAuthorizationHeader(String serverPrincipalName) throws GSSException, LoginException, KrbException, IOException {
        String clientPrincipal = this.getClientPrincipalName();
        CreateAuthorizationHeaderAction action = new CreateAuthorizationHeaderAction(clientPrincipal, serverPrincipalName);
        Set<Object> privateCreds = this.loginContext.getSubject().getPrivateCredentials();
        for (Object privateCred : privateCreds) {
            String serverPrincipalTicketName;
            if (!(privateCred instanceof KerberosTicket) || !(serverPrincipalTicketName = ((KerberosTicket)privateCred).getServer().getName()).startsWith("krbtgt") || ((KerberosTicket)privateCred).getEndTime().compareTo(new Date()) != -1) continue;
            this.buildSubjectCredentials();
            break;
        }
        Subject.doAs(this.loginContext.getSubject(), action);
        return action.getNegotiateToken();
    }

    private String getClientPrincipalName() {
        Set<Principal> principalSet = this.loginContext.getSubject().getPrincipals();
        if (principalSet.size() != 1) {
            throw new IllegalStateException("Only one principal per subject is expected. Found 0 or more than one principals :" + principalSet);
        }
        return principalSet.iterator().next().getName();
    }

    public class PDCloudAuthConfig {
        private final char[] apiKey;
        private final String tokenEndpoint;
        private final String grantType;
        private final int tokenDuration;

        public PDCloudAuthConfig(char[] apiKey, String tokenEndpoint, String grantType, int tokenDuration) {
            this.apiKey = apiKey;
            this.tokenEndpoint = tokenEndpoint == null ? Credentials.DEFAULT_TOKEN_ENDPOINT : tokenEndpoint;
            this.grantType = grantType == null ? Credentials.DEFAULT_GRANT_TYPE : grantType;
            this.tokenDuration = tokenDuration == 0 ? 60 : tokenDuration;
        }

        public char[] getApiKey() {
            return this.apiKey;
        }

        public String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        public String getGrantType() {
            return this.grantType;
        }

        public int getTokenDuration() {
            return this.tokenDuration;
        }
    }

    private static class CreateAuthorizationHeaderAction
    implements PrivilegedAction {
        String clientPrincipalName;
        String serverPrincipalName;
        private StringBuffer outputToken = new StringBuffer();

        private CreateAuthorizationHeaderAction(String clientPrincipalName, String serverPrincipalName) {
            this.clientPrincipalName = clientPrincipalName;
            this.serverPrincipalName = serverPrincipalName;
        }

        private String getNegotiateToken() {
            return this.outputToken.toString();
        }

        public Object run() {
            try {
                Oid krb5Mechanism = new Oid("1.2.840.113554.1.2.2");
                Oid krb5PrincipalNameType = new Oid("1.2.840.113554.1.2.2.1");
                GSSManager manager = GSSManager.getInstance();
                GSSName clientName = manager.createName(this.clientPrincipalName, krb5PrincipalNameType);
                GSSCredential clientCred = manager.createCredential(clientName, 28800, krb5Mechanism, 1);
                GSSName serverName = manager.createName(this.serverPrincipalName, krb5PrincipalNameType);
                GSSContext context = manager.createContext(serverName, krb5Mechanism, clientCred, 0);
                byte[] inToken = new byte[]{};
                byte[] outToken = context.initSecContext(inToken, 0, inToken.length);
                this.outputToken.append(new String(Base64.encodeBytes(outToken, 8)));
                context.dispose();
            }
            catch (GSSException exception) {
                throw new RuntimeException(exception.getMessage());
            }
            return null;
        }
    }

    private class KerberosLoginConfiguration
    extends Configuration {
        private KerberosLoginConfiguration() {
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("refreshKrb5Config", "true");
            options.put("useTicketCache", "true");
            return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

