/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.http.HttpChannel;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.exceptions.PDCloudRequestException;
import com.marklogic.xcc.impl.Credentials;
import com.marklogic.xcc.impl.PDCloudAuthManager;
import com.marklogic.xcc.impl.handlers.ResponseHandler;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PDCloudSuccessResponseHandler
implements ResponseHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object handleResponse(HttpChannel http, int responseCode, Request request, Object attachment, Logger logger) throws IOException, PDCloudRequestException {
        String contentType = http.getResponseContentType();
        if (!contentType.equals("application/json")) throw new PDCloudRequestException("Malformed response body from Progress Data Cloud. Please report to Customer Support.", request, false);
        JsonNode jsonMap = http.getResponseJsonBody();
        String sessionToken = jsonMap.get("access_token").textValue();
        String expiration = jsonMap.get(".expires").textValue();
        long duration = jsonMap.get("expires_in").longValue();
        try {
            if (!(attachment instanceof Credentials.PDCloudAuthConfig)) return null;
            PDCloudAuthManager.setTokenConfig(((Credentials.PDCloudAuthConfig)attachment).getApiKey(), sessionToken.toCharArray(), this.tokenExpirationInMillis(expiration), duration);
            if (!logger.isLoggable(Level.FINE)) return null;
            logger.log(Level.FINE, "Successfully obtained sessiontoken from MarkLogic Cloud token endpoint.");
            return null;
        }
        catch (ParseException e) {
            throw new PDCloudRequestException("Exception parsing Progress Data Cloud response body. " + e.getMessage(), request, false);
        }
    }

    private long tokenExpirationInMillis(String dateString) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        Date date = sdf.parse(dateString);
        return date.getTime();
    }
}

