/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw;

import java.io.InputStream;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.jena.atlas.data.BagFactory;
import org.apache.jena.atlas.data.DataBag;
import org.apache.jena.atlas.data.DefaultDataBag;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.rowset.RowSetReader;
import org.apache.jena.riot.rowset.RowSetReaderFactory;
import org.apache.jena.riot.rowset.rw.rs_json.RowSetBuffered;
import org.apache.jena.riot.rowset.rw.rs_json.RowSetJSONStreaming;
import org.apache.jena.riot.rowset.rw.rs_json.Severity;
import org.apache.jena.riot.rowset.rw.rs_json.ValidationSettings;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExecResult;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.system.SerializationFactoryFinder;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowSetReaderJSONStreaming
implements RowSetReader {
    private static final Logger log = LoggerFactory.getLogger(RowSetReaderJSONStreaming.class);
    public static final Symbol rsJsonSearchHeadEagerly = SystemARQ.allocSymbol("rsJsonSearchHeadEagerly");
    public static final Symbol rsJsonSeverityEmptyJson = SystemARQ.allocSymbol("rsJsonSeverityEmptyJson");
    public static final Symbol rsJsonSeverityMissingHead = SystemARQ.allocSymbol("rsJsonSeverityMissingHead");
    public static final Symbol rsJsonSeverityInvalidatedResults = SystemARQ.allocSymbol("rsJsonSeverityInvalidatedResults");
    public static final Symbol rsJsonSeverityInvalidatedHead = SystemARQ.allocSymbol("rsJsonSeverityInvalidatedHead");
    public static final Symbol rsJsonSeverityMixedResults = SystemARQ.allocSymbol("rsJsonSeverityMixedResults");
    public static final Symbol rsJsonSeverityUnexpectedJsonElement = SystemARQ.allocSymbol("rsJsonSeverityUnexpectedJsonElement");
    public static final RowSetReaderFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_JSON)) {
            throw new ResultSetException("RowSet for JSON asked for a " + lang);
        }
        return new RowSetReaderJSONStreaming();
    };

    @Override
    public QueryExecResult readAny(InputStream in, Context context2) {
        return RowSetReaderJSONStreaming.process(in, context2);
    }

    public static QueryExecResult process(InputStream in, Context context2) {
        RowSetJSONStreaming<?> inner;
        Boolean askResult;
        context2 = context2 == null ? ARQ.getContext() : context2;
        QueryExecResult result = null;
        RowSetBuffered<RowSetJSONStreaming<?>> rs = RowSetReaderJSONStreaming.createRowSet(in, context2);
        Boolean searchHeaderEagerly = context2.get(rsJsonSearchHeadEagerly, false);
        if (Boolean.TRUE.equals(searchHeaderEagerly)) {
            rs.getResultVars();
        }
        if (!rs.hasNext() && (askResult = (inner = rs.getDelegate()).getAskResult()) != null) {
            result = new QueryExecResult(askResult);
        }
        if (result == null) {
            result = new QueryExecResult(rs);
        }
        return result;
    }

    public static RowSetBuffered<RowSetJSONStreaming<?>> createRowSet(InputStream in, Context context2) {
        Context cxt = context2 == null ? ARQ.getContext() : context2;
        boolean inputGraphBNodeLabels = cxt.isTrue(ARQ.inputGraphBNodeLabels);
        LabelToNode labelMap = inputGraphBNodeLabels ? SyntaxLabels.createLabelToNodeAsGiven() : SyntaxLabels.createLabelToNode();
        Supplier<DataBag<Binding>> bufferFactory = () -> {
            ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(cxt);
            DefaultDataBag<Binding> r = BagFactory.newDefaultBag(policy, SerializationFactoryFinder.bindingSerializationFactory());
            return r;
        };
        ValidationSettings validationSettings = RowSetReaderJSONStreaming.configureValidationFromContext(new ValidationSettings(), cxt);
        return RowSetJSONStreaming.createBuffered(in, labelMap, bufferFactory, validationSettings, ErrorHandlerFactory.errorHandlerWarnOrExceptions(log));
    }

    public static ValidationSettings configureValidationFromContext(ValidationSettings settings, Context cxt) {
        Severity severity = (Severity)((Object)cxt.get(rsJsonSeverityEmptyJson));
        if (severity != null) {
            settings.setEmptyJsonSeverity(severity);
        }
        if ((severity = (Severity)((Object)cxt.get(rsJsonSeverityMissingHead))) != null) {
            settings.setMissingHeadSeverity(severity);
        }
        if ((severity = (Severity)((Object)cxt.get(rsJsonSeverityInvalidatedResults))) != null) {
            settings.setInvalidatedResultsSeverity(severity);
        }
        if ((severity = (Severity)((Object)cxt.get(rsJsonSeverityInvalidatedHead))) != null) {
            settings.setInvalidatedHeadSeverity(severity);
        }
        if ((severity = (Severity)((Object)cxt.get(rsJsonSeverityMixedResults))) != null) {
            settings.setMixedResultsSeverity(severity);
        }
        if ((severity = (Severity)((Object)cxt.get(rsJsonSeverityUnexpectedJsonElement))) != null) {
            settings.setUnexpectedJsonElementSeverity(severity);
        }
        return settings;
    }
}

