/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc;

import com.marklogic.xcc.AdhocQuery;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.ContentbaseMetaData;
import com.marklogic.xcc.ModuleInvoke;
import com.marklogic.xcc.ModuleSpawn;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.RequestOptions;
import com.marklogic.xcc.ResultSequence;
import com.marklogic.xcc.UserCredentials;
import com.marklogic.xcc.exceptions.RequestException;
import java.io.Closeable;
import java.math.BigInteger;
import java.net.URI;
import java.util.List;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;

public interface Session
extends Closeable {
    public ContentSource getContentSource();

    public UserCredentials getUserCredentials();

    public String getContentBaseName();

    public XAResource getXAResource();

    @Deprecated
    public void setTransactionMode(TransactionMode var1);

    @Deprecated
    public TransactionMode getTransactionMode();

    public boolean isAutoCommit();

    public void setAutoCommit(boolean var1);

    public Update getUpdate();

    public void setUpdate(Update var1);

    public void setTransactionTimeout(int var1) throws RequestException;

    public int getTransactionTimeout() throws RequestException;

    public int getCachedTxnTimeout();

    public boolean commit() throws RequestException;

    public void rollback() throws RequestException;

    @Override
    public void close();

    public boolean isClosed();

    public ResultSequence submitRequest(Request var1) throws RequestException;

    public AdhocQuery newAdhocQuery(String var1, RequestOptions var2);

    public AdhocQuery newAdhocQuery(String var1);

    public ModuleInvoke newModuleInvoke(String var1, RequestOptions var2);

    public ModuleInvoke newModuleInvoke(String var1);

    public ModuleSpawn newModuleSpawn(String var1, RequestOptions var2);

    public ModuleSpawn newModuleSpawn(String var1);

    public void insertContent(Content var1) throws RequestException;

    public void insertContent(Content[] var1) throws RequestException;

    public List<RequestException> insertContentCollectErrors(Content[] var1) throws RequestException;

    public ContentbaseMetaData getContentbaseMetaData();

    public void setDefaultRequestOptions(RequestOptions var1);

    public RequestOptions getDefaultRequestOptions();

    public RequestOptions getEffectiveRequestOptions();

    public BigInteger getCurrentServerPointInTime() throws RequestException;

    public Logger getLogger();

    public void setLogger(Logger var1);

    public void setUserObject(Object var1);

    public Object getUserObject();

    public URI getConnectionUri();

    @Deprecated
    public static enum TransactionMode {
        AUTO{

            @Override
            public String toString() {
                return "auto";
            }

            @Override
            public Update getUpdate() {
                return Update.AUTO;
            }

            @Override
            public TransactionMode setAutoCommit(boolean autoCommit) {
                if (autoCommit) {
                    return this;
                }
                return MULTI_AUTO;
            }

            @Override
            public TransactionMode setUpdate(Update update) {
                switch (update) {
                    case TRUE: {
                        return UPDATE_AUTO_COMMIT;
                    }
                    case FALSE: {
                        return QUERY_SINGLE_STATEMENT;
                    }
                }
                return this;
            }
        }
        ,
        QUERY{

            @Override
            public String toString() {
                return "query";
            }

            @Override
            public boolean isAutoCommit() {
                return false;
            }

            @Override
            public Update getUpdate() {
                return Update.FALSE;
            }

            @Override
            public TransactionMode setAutoCommit(boolean autoCommit) {
                if (autoCommit) {
                    return QUERY_SINGLE_STATEMENT;
                }
                return this;
            }

            @Override
            public TransactionMode setUpdate(Update update) {
                switch (update) {
                    case AUTO: {
                        return MULTI_AUTO;
                    }
                    case TRUE: {
                        return UPDATE;
                    }
                }
                return this;
            }
        }
        ,
        UPDATE{

            @Override
            public String toString() {
                return "update";
            }

            @Override
            public boolean isRetryable() {
                return false;
            }

            @Override
            public boolean isAutoCommit() {
                return false;
            }

            @Override
            public Update getUpdate() {
                return Update.TRUE;
            }

            @Override
            public TransactionMode setAutoCommit(boolean autoCommit) {
                if (autoCommit) {
                    return UPDATE_AUTO_COMMIT;
                }
                return this;
            }

            @Override
            public TransactionMode setUpdate(Update update) {
                switch (update) {
                    case AUTO: {
                        return MULTI_AUTO;
                    }
                    case FALSE: {
                        return QUERY;
                    }
                }
                return this;
            }
        }
        ,
        UPDATE_AUTO_COMMIT{

            @Override
            public String toString() {
                return "update-auto-commit";
            }

            @Override
            public Update getUpdate() {
                return Update.TRUE;
            }

            @Override
            public TransactionMode setAutoCommit(boolean autoCommit) {
                if (autoCommit) {
                    return this;
                }
                return UPDATE;
            }

            @Override
            public TransactionMode setUpdate(Update update) {
                switch (update) {
                    case AUTO: {
                        return AUTO;
                    }
                    case FALSE: {
                        return QUERY_SINGLE_STATEMENT;
                    }
                }
                return this;
            }
        }
        ,
        QUERY_SINGLE_STATEMENT{

            @Override
            public String toString() {
                return "query-single-statement";
            }

            @Override
            public Update getUpdate() {
                return Update.FALSE;
            }

            @Override
            public TransactionMode setAutoCommit(boolean autoCommit) {
                if (autoCommit) {
                    return this;
                }
                return QUERY;
            }

            @Override
            public TransactionMode setUpdate(Update update) {
                switch (update) {
                    case AUTO: {
                        return AUTO;
                    }
                    case TRUE: {
                        return UPDATE_AUTO_COMMIT;
                    }
                }
                return this;
            }
        }
        ,
        MULTI_AUTO{

            @Override
            public String toString() {
                return "multi-auto";
            }

            @Override
            public boolean isAutoCommit() {
                return false;
            }

            @Override
            public Update getUpdate() {
                return Update.AUTO;
            }

            @Override
            public TransactionMode setAutoCommit(boolean autoCommit) {
                if (autoCommit) {
                    return AUTO;
                }
                return this;
            }

            @Override
            public TransactionMode setUpdate(Update update) {
                switch (update) {
                    case TRUE: {
                        return UPDATE;
                    }
                    case FALSE: {
                        return QUERY;
                    }
                }
                return this;
            }
        };


        public abstract String toString();

        public boolean isRetryable() {
            return true;
        }

        public boolean isAutoCommit() {
            return true;
        }

        public abstract TransactionMode setAutoCommit(boolean var1);

        public abstract Update getUpdate();

        public abstract TransactionMode setUpdate(Update var1);
    }

    public static enum Update {
        AUTO,
        TRUE,
        FALSE;

    }
}

