/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.xcc.impl.handlers;

import com.marklogic.http.HttpChannel;
import com.marklogic.io.IOHelper;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentFactory;
import com.marklogic.xcc.Request;
import com.marklogic.xcc.exceptions.ContentInsertEntityException;
import com.marklogic.xcc.exceptions.ContentInsertException;
import com.marklogic.xcc.exceptions.RequestException;
import com.marklogic.xcc.impl.handlers.ContentInsertController;
import com.marklogic.xcc.impl.handlers.ResponseHandler;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;

public class EntityResolveHandler
implements ResponseHandler {
    @Override
    public Object handleResponse(HttpChannel http, int responseCode, Request request, Object attachment, Logger logger) throws RequestException, IOException {
        String location = http.getResponseHeader("location");
        Content content = (Content)attachment;
        logger.fine("creating Content object to resolve entity '" + location + "' from '" + content.getUri() + "'");
        return this.buildEntityContent(location, request, content);
    }

    ContentInsertController.ContentDecorator buildEntityContent(String location, Request request, Content content) throws IOException, ContentInsertException {
        try {
            Content entity = this.createEntityContent(request, location, content);
            return new ContentInsertController.ContentDecorator(entity, content, location);
        }
        catch (URISyntaxException e) {
            throw new ContentInsertEntityException("URI requested by server for entity resolution is not valid syntax: " + location, request, content, location, e);
        }
    }

    private Content createEntityContent(Request request, String location, Content parent) throws IOException, URISyntaxException, ContentInsertEntityException {
        if (location.startsWith("file:/")) {
            return this.createFileContent(request, location, parent);
        }
        if (location.startsWith("/")) {
            return this.createFileContent(request, "file:" + location, parent);
        }
        return ContentFactory.newContent(location, new URI(location), null);
    }

    private Content createFileContent(Request request, String location, Content parent) throws ContentInsertEntityException {
        String path = location.substring(location.startsWith("file:///") ? 7 : 5);
        File file = new File(path);
        String errorMsg = null;
        if (!file.exists()) {
            file = new File(IOHelper.urlDecodeString(path));
        }
        if (!file.exists()) {
            errorMsg = "Entity '" + location + "' does not exist";
        }
        if (errorMsg == null && !file.isFile()) {
            errorMsg = "Entity '" + location + "' exists, but is not a file";
        }
        if (errorMsg == null && !file.canRead()) {
            errorMsg = "Entity '" + location + "' is not readable";
        }
        if (errorMsg != null) {
            throw new ContentInsertEntityException(errorMsg, request, parent, location);
        }
        return ContentFactory.newContent(location, file, null);
    }
}

