/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.mapreduce.CustomContent;
import com.marklogic.mapreduce.MarkLogicNode;
import com.marklogic.xcc.Content;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.w3c.dom.Node;

public class ContentWithFileNameWritable<VALUE>
implements CustomContent {
    public static final Log LOG = LogFactory.getLog(ContentWithFileNameWritable.class);
    private VALUE value;
    private String fileName;
    private byte type;

    public ContentWithFileNameWritable() {
    }

    public ContentWithFileNameWritable(VALUE value, String fileName) {
        this.value = value;
        this.fileName = fileName;
        if (value instanceof Text) {
            this.type = 0;
        } else if (value instanceof MarkLogicNode) {
            this.type = 1;
        } else if (value instanceof BytesWritable) {
            this.type = (byte)2;
        }
    }

    public VALUE getValue() {
        return this.value;
    }

    public void setValue(VALUE value) {
        this.value = value;
        if (value instanceof Text) {
            this.type = 0;
        } else if (value instanceof MarkLogicNode) {
            this.type = 1;
        } else if (value instanceof BytesWritable) {
            this.type = (byte)2;
        }
    }

    public String getFileName() {
        return this.fileName.toString();
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public Content getContent(Configuration conf, ContentCreateOptions options, String uri) {
        String[] collections = conf.getStrings("mapreduce.marklogic.output.content.collection");
        String collectionUri = null;
        try {
            URI fileUri = new URI(null, null, null, 0, this.fileName, null, null);
            collectionUri = fileUri.toString();
        }
        catch (URISyntaxException e) {
            LOG.error((Object)("Error parsing file name as URI " + this.fileName), (Throwable)e);
        }
        if (collections != null) {
            ArrayList<String> optionList = new ArrayList<String>();
            Collections.addAll(optionList, collections);
            if (collectionUri != null) {
                optionList.add(collectionUri);
            }
            collections = optionList.toArray(new String[0]);
            for (int i = 0; i < collections.length; ++i) {
                collections[i] = collections[i].trim();
            }
            options.setCollections(collections);
        } else {
            String[] col = new String[]{collectionUri};
            options.setCollections(col);
        }
        Content content = null;
        if (this.value instanceof Text) {
            content = ContentFactory.newContent((String)uri, (String)((Text)this.value).toString(), (ContentCreateOptions)options);
        } else if (this.value instanceof MarkLogicNode) {
            content = ContentFactory.newContent((String)uri, (Node)((MarkLogicNode)this.value).get(), (ContentCreateOptions)options);
        } else if (this.value instanceof BytesWritable) {
            content = ContentFactory.newContent((String)uri, (byte[])((BytesWritable)this.value).getBytes(), (int)0, (int)((BytesWritable)this.value).getLength(), (ContentCreateOptions)options);
        }
        return content;
    }

    public void readFields(DataInput in) throws IOException {
        String fn;
        this.fileName = fn = Text.readString((DataInput)in);
        byte valueType = in.readByte();
        switch (valueType) {
            case 0: {
                this.value = new Text();
                ((Text)this.value).readFields(in);
                break;
            }
            case 1: {
                this.value = new MarkLogicNode();
                ((MarkLogicNode)this.value).readFields(in);
                break;
            }
            case 2: {
                this.value = new BytesWritable();
                ((BytesWritable)this.value).readFields(in);
                break;
            }
            default: {
                throw new IOException("incorrect type");
            }
        }
        this.type = valueType;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.fileName);
        out.writeByte(this.type);
        if (this.value instanceof Text) {
            ((Text)this.value).write(out);
        } else if (this.value instanceof MarkLogicNode) {
            ((MarkLogicNode)this.value).write(out);
        } else if (this.value instanceof BytesWritable) {
            ((BytesWritable)this.value).write(out);
        }
    }

    protected String getEncodedURI(String val) {
        try {
            URI uri = new URI(null, null, null, 0, val, null, null);
            return uri.toString();
        }
        catch (URISyntaxException e) {
            LOG.error((Object)("Error parsing value as URI, skipping " + val), (Throwable)e);
            return null;
        }
    }
}

