/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.ConfigConstants;
import com.marklogic.contentpump.DatabaseContentWriter;
import com.marklogic.contentpump.DatabaseDocumentWithMeta;
import com.marklogic.contentpump.DocumentMetadata;
import com.marklogic.contentpump.TransformWriter;
import com.marklogic.mapreduce.DocumentURI;
import com.marklogic.mapreduce.utilities.AssignmentManager;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import com.marklogic.xcc.ContentCreateOptions;
import com.marklogic.xcc.ContentSource;
import com.marklogic.xcc.exceptions.PDCloudRequestException;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;

public class DatabaseTransformWriter<VALUE>
extends TransformWriter<VALUE>
implements ConfigConstants {
    public static final Log LOG = LogFactory.getLog(DatabaseTransformWriter.class);
    protected boolean isCopyProps;
    protected boolean isCopyPerms;

    public DatabaseTransformWriter(Configuration conf, Map<String, ContentSource> hostSourceMap, boolean fastLoad, AssignmentManager am) {
        super(conf, hostSourceMap, fastLoad, am);
        this.isCopyProps = conf.getBoolean("mapreduce.marklogic.copyproperties", true);
        this.isCopyPerms = conf.getBoolean("mapreduce.marklogic.copypermissions", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DocumentURI key, VALUE value) throws IOException, InterruptedException {
        int fId = 0;
        String uri = InternalUtilities.getUriWithOutputDir(key, this.outputDir);
        if (this.fastLoad) {
            if (!this.countBased) {
                this.sfId = fId = this.am.getPlacementForestIndex(key);
            } else {
                if (this.sfId == -1) {
                    this.sfId = this.am.getPlacementForestIndex(key);
                }
                fId = this.sfId;
            }
        }
        int sid = fId;
        DatabaseDocumentWithMeta doc = (DatabaseDocumentWithMeta)value;
        DocumentMetadata meta = doc.getMeta();
        ContentCreateOptions opt = DatabaseContentWriter.newContentCreateOptions(meta, this.options, this.isCopyColls, this.isCopyQuality, this.isCopyMeta, this.isCopyPerms, this.effectiveVersion);
        boolean naked = meta.isNakedProps();
        if (this.sessions[sid] == null) {
            this.sessions[sid] = this.getSession(sid, false);
            this.queries[sid] = this.getAdhocQuery(sid);
        }
        boolean committed = false;
        if (!naked) {
            opt.setFormat(doc.getContentType().getDocumentFormat());
            this.addValue(uri, value, sid, opt, this.effectiveVersion < 9000400L ? null : meta.getProperties());
            this.pendingURIs[sid].add((DocumentURI)key.clone());
            int n = sid;
            this.counts[n] = this.counts[n] + 1;
            if (this.counts[n] == this.batchSize) {
                this.commitRetry = 0;
                this.commitSleepTime = 500;
                while (this.commitRetry < this.commitRetryLimit) {
                    committed = false;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getFormattedBatchId() + "Retrying committing batch , attempts: " + this.commitRetry + "/15"));
                    }
                    this.queries[sid].setNewVariables(this.uriName, this.uris[sid]);
                    this.queries[sid].setNewVariables(this.contentName, this.values[sid]);
                    this.queries[sid].setNewVariables(this.optionsName, this.optionsVals[sid]);
                    try {
                        this.insertBatch(sid, this.uris[sid], this.values[sid], this.optionsVals[sid]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int n2 = sid;
                    this.stmtCounts[n2] = this.stmtCounts[n2] + 1;
                    if (this.countBased) {
                        this.sfId = -1;
                    }
                    this.counts[fId] = 0;
                    if (!this.needCommit || this.stmtCounts[sid] != this.txnSize) break;
                    try {
                        this.commit(sid);
                        if (this.commitRetry <= 0) break;
                        LOG.info((Object)(this.getFormattedBatchId() + "Retrying committing batch is successful"));
                        break;
                    }
                    catch (Exception e) {
                        boolean isRetryable = true;
                        LOG.warn((Object)"Failed committing transaction.");
                        if (e instanceof PDCloudRequestException) {
                            isRetryable = ((PDCloudRequestException)e).isRetryable();
                            LOG.warn((Object)(this.getFormattedBatchId() + "PDCloudRequestException:" + e.getMessage()));
                        } else {
                            LOG.warn((Object)(this.getFormattedBatchId() + "Exception:" + e.getMessage()));
                        }
                        if (isRetryable && this.needCommitRetry() && ++this.commitRetry < this.commitRetryLimit) {
                            LOG.warn((Object)(this.getFormattedBatchId() + "Failed during committing"));
                            this.handleCommitExceptions(sid);
                            this.commitSleepTime = this.sleep(this.commitSleepTime);
                            this.stmtCounts[sid] = 0;
                            this.sessions[sid] = this.getSession(sid, true);
                            continue;
                        }
                        if (this.needCommitRetry()) {
                            LOG.error((Object)(this.getFormattedBatchId() + "Exceeded max commit retry, batch failed permanently"));
                        }
                        this.failed += this.commitUris[sid].size();
                        for (DocumentURI failedUri : this.commitUris[sid]) {
                            LOG.error((Object)(this.getFormattedBatchId() + "Document failed permanently: " + failedUri));
                        }
                        this.handleCommitExceptions(sid);
                        break;
                    }
                    finally {
                        this.stmtCounts[sid] = 0;
                        committed = true;
                    }
                }
                ++this.batchId;
                this.pendingURIs[sid].clear();
            }
        }
        if (this.isCopyProps && meta.getProperties() != null && (this.effectiveVersion < 9000400L || naked)) {
            boolean suc = DatabaseContentWriter.setDocumentProperties(uri, meta.getProperties(), this.isCopyPerms && naked ? meta.getPermString() : null, this.isCopyColls && naked ? meta.getCollectionString() : null, this.isCopyQuality && naked ? meta.getQualityString() : null, this.isCopyMeta && naked ? meta.getMeta() : null, this.sessions[sid]);
            int n = sid;
            this.stmtCounts[n] = this.stmtCounts[n] + 1;
            if (suc && naked) {
                if (this.needCommit) {
                    this.commitUris[sid].add(key);
                } else {
                    ++this.succeeded;
                }
            } else if (!suc && naked) {
                ++this.failed;
            }
        }
        if (this.needCommit && this.stmtCounts[sid] >= this.txnSize) {
            try {
                this.commit(sid);
            }
            catch (Exception e) {
                LOG.warn((Object)(this.getFormattedBatchId() + "Failed committing transaction: " + e.getMessage()));
                this.handleCommitExceptions(sid);
            }
            this.stmtCounts[sid] = 0;
            committed = true;
        }
        if (!(this.fastLoad || this.needCommit && !committed)) {
            this.hostId = (this.hostId + 1) % this.forestIds.length;
            this.sessions[0] = null;
            this.queries[0] = null;
        }
    }
}

