/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.BaseMapper;
import com.marklogic.contentpump.utilities.ReflectionUtil;
import com.marklogic.mapreduce.utilities.InternalUtilities;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;

public class MultithreadedMapper<K1, V1, K2, V2>
extends Mapper<K1, V1, K2, V2> {
    private static final Log LOG = LogFactory.getLog(MultithreadedMapper.class);
    private Class<? extends BaseMapper<K1, V1, K2, V2>> mapClass;
    private Mapper.Context outer;
    private List<MapRunner> runnerList = new ArrayList<MapRunner>();
    private List<Future<?>> runnerFutureList = new ArrayList();
    private int threadCount = 0;
    private ThreadPoolExecutor threadPool;

    public int getThreadCount(Mapper.Context context) {
        if (this.threadCount > 0) {
            return this.threadCount;
        }
        return MultithreadedMapper.getNumberOfThreads((JobContext)context);
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void setThreadPool(ThreadPoolExecutor pool) {
        this.threadPool = pool;
    }

    public static int getNumberOfThreads(JobContext job) {
        return job.getConfiguration().getInt("mapreduce.marklogic.multithreadedmapper.threads", 4);
    }

    public static void setNumberOfThreads(Job job, int threads) {
        job.getConfiguration().setInt("mapreduce.marklogic.multithreadedmapper.threads", threads);
    }

    public static void setNumberOfThreads(Configuration conf, int threads) {
        conf.setInt("mapreduce.marklogic.multithreadedmapper.threads", threads);
    }

    public static <K1, V1, K2, V2> Class<BaseMapper<K1, V1, K2, V2>> getMapperClass(JobContext job) {
        Configuration conf = job.getConfiguration();
        return conf.getClass("mapreduce.marklogic.multithreadedmapper.class", BaseMapper.class);
    }

    public static <K1, V1, K2, V2> void setMapperClass(Configuration conf, Class<? extends BaseMapper<?, ?, ?, ?>> internalMapperClass) {
        if (MultithreadedMapper.class.isAssignableFrom(internalMapperClass)) {
            throw new IllegalArgumentException("Can't have recursive MultithreadedMapper instances.");
        }
        conf.setClass("mapreduce.marklogic.multithreadedmapper.class", internalMapperClass, Mapper.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRunners(int numRunners) throws IOException, InterruptedException, ClassNotFoundException {
        ThreadPoolExecutor threadPoolExecutor = this.threadPool;
        synchronized (threadPoolExecutor) {
            for (int i = 0; i < numRunners; ++i) {
                MapRunner runner = new MapRunner();
                List<Future<?>> list = this.runnerFutureList;
                synchronized (list) {
                    this.runnerList.add(runner);
                    if (this.threadPool.isShutdown()) {
                        throw new InterruptedException("Thread Pool has been shut down");
                    }
                    Future<?> future = this.threadPool.submit(runner);
                    this.runnerFutureList.add(future);
                    continue;
                }
            }
            this.threadPool.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRunners(int numRunners) {
        for (int i = 0; i < numRunners; ++i) {
            this.runnerList.get(this.runnerList.size() - i - 1).setShutdown(true);
        }
        while (true) {
            boolean allDone = true;
            List<MapRunner> list = this.runnerList;
            synchronized (list) {
                for (int i = 0; i < numRunners; ++i) {
                    allDone &= this.runnerList.get(this.runnerList.size() - i - 1).getIsShutdownDone();
                }
            }
            if (allDone) break;
            try {
                InternalUtilities.sleep(500L);
            }
            catch (Exception exception) {}
        }
        List<Future<?>> list = this.runnerFutureList;
        synchronized (list) {
            for (int i = 0; i < numRunners; ++i) {
                this.runnerList.remove(this.runnerList.size() - 1);
                this.runnerFutureList.remove(this.runnerFutureList.size() - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Mapper.Context context) throws IOException, InterruptedException {
        block17: {
            this.outer = context;
            int numberOfThreads = this.getThreadCount(context);
            this.mapClass = MultithreadedMapper.getMapperClass((JobContext)context);
            --numberOfThreads;
            try {
                if (this.threadPool != null) {
                    boolean allDone232;
                    this.createRunners(numberOfThreads);
                    MapRunner r = new MapRunner();
                    r.run();
                    do {
                        allDone232 = true;
                        List<Future<?>> list = this.runnerFutureList;
                        synchronized (list) {
                            for (Future<?> f : this.runnerFutureList) {
                                allDone232 &= f.isDone();
                            }
                        }
                    } while (!allDone232);
                    List<Future<?>> allDone232 = this.runnerFutureList;
                    synchronized (allDone232) {
                        for (Future future : this.runnerFutureList) {
                            future.get();
                        }
                        break block17;
                    }
                }
                for (int i = 0; i < numberOfThreads; ++i) {
                    MapRunner thread = new MapRunner();
                    thread.start();
                    this.runnerList.add(i, thread);
                }
                MapRunner r = new MapRunner();
                r.run();
                for (int i = 0; i < numberOfThreads; ++i) {
                    MapRunner thread = this.runnerList.get(i);
                    thread.join();
                    Throwable throwable = thread.throwable;
                    if (throwable == null) continue;
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    if (throwable instanceof InterruptedException) {
                        throw (InterruptedException)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)"MapRunner class not found", (Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.error((Object)"Error waiting for MapRunner threads to complete", (Throwable)e);
            }
        }
    }

    protected class MapRunner
    extends Thread {
        private BaseMapper<K1, V1, K2, V2> mapper;
        private Mapper.Context subcontext;
        private Throwable throwable;
        private RecordWriter<K2, V2> writer;
        AtomicBoolean shutdown = new AtomicBoolean(false);
        AtomicBoolean isShutdownDone = new AtomicBoolean(false);

        MapRunner() throws IOException, ClassNotFoundException {
            this.mapper = (BaseMapper)((Object)ReflectionUtils.newInstance(MultithreadedMapper.this.mapClass, (Configuration)MultithreadedMapper.this.outer.getConfiguration()));
            OutputFormat outputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)MultithreadedMapper.this.outer.getOutputFormatClass(), (Configuration)MultithreadedMapper.this.outer.getConfiguration());
            try {
                this.writer = outputFormat.getRecordWriter((TaskAttemptContext)MultithreadedMapper.this.outer);
                this.subcontext = ReflectionUtil.createMapperContext(this.mapper, MultithreadedMapper.this.outer.getConfiguration(), MultithreadedMapper.this.outer.getTaskAttemptID(), new SubMapRecordReader(), this.writer, MultithreadedMapper.this.outer.getOutputCommitter(), new SubMapStatusReporter(), MultithreadedMapper.this.outer.getInputSplit());
            }
            catch (Exception e) {
                throw new IOException("Error creating mapper context", e);
            }
        }

        public BaseMapper<K1, V1, K2, V2> getMapper() {
            return this.mapper;
        }

        @Override
        public void run() {
            block5: {
                block4: {
                    try {
                        this.mapper.runThreadSafe(MultithreadedMapper.this.outer, this.subcontext, this);
                    }
                    catch (Throwable ie) {
                        if (!LOG.isDebugEnabled()) break block4;
                        LOG.debug((Object)("Error running task:" + ie));
                        ie.printStackTrace();
                    }
                }
                try {
                    this.writer.close((TaskAttemptContext)this.subcontext);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error closing writer: " + t.getMessage()));
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)t);
                }
            }
            this.isShutdownDone.set(true);
        }

        public void setShutdown(boolean shutdown) {
            this.shutdown.set(shutdown);
        }

        public boolean getShutdown() {
            return this.shutdown.get();
        }

        public boolean getIsShutdownDone() {
            return this.isShutdownDone.get();
        }
    }

    private class SubMapStatusReporter
    extends StatusReporter {
        private SubMapStatusReporter() {
        }

        public Counter getCounter(Enum<?> name) {
            return MultithreadedMapper.this.outer.getCounter(name);
        }

        public Counter getCounter(String group, String name) {
            return MultithreadedMapper.this.outer.getCounter(group, name);
        }

        public void progress() {
            MultithreadedMapper.this.outer.progress();
        }

        public void setStatus(String status) {
            MultithreadedMapper.this.outer.setStatus(status);
        }

        public float getProgress() {
            try {
                Method getProgressMethod = MultithreadedMapper.this.outer.getClass().getMethod("getProgress", new Class[0]);
                if (getProgressMethod != null) {
                    return ((Float)getProgressMethod.invoke((Object)MultithreadedMapper.this.outer, new Object[0])).floatValue();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error getting progress", (Throwable)e);
            }
            return 0.0f;
        }
    }

    private class SubMapRecordReader
    extends RecordReader<K1, V1> {
        private K1 key;
        private V1 value;

        private SubMapRecordReader() {
        }

        public void close() throws IOException {
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (!MultithreadedMapper.this.outer.nextKeyValue()) {
                return false;
            }
            if (MultithreadedMapper.this.outer.getCurrentKey() == null) {
                return true;
            }
            this.key = ReflectionUtils.newInstance(MultithreadedMapper.this.outer.getCurrentKey().getClass(), (Configuration)MultithreadedMapper.this.outer.getConfiguration());
            this.key = ReflectionUtils.copy((Configuration)MultithreadedMapper.this.outer.getConfiguration(), (Object)MultithreadedMapper.this.outer.getCurrentKey(), this.key);
            Object outerVal = MultithreadedMapper.this.outer.getCurrentValue();
            if (outerVal != null) {
                this.value = ReflectionUtils.newInstance(outerVal.getClass(), (Configuration)MultithreadedMapper.this.outer.getConfiguration());
                this.value = ReflectionUtils.copy((Configuration)MultithreadedMapper.this.outer.getConfiguration(), (Object)MultithreadedMapper.this.outer.getCurrentValue(), this.value);
            }
            return true;
        }

        public K1 getCurrentKey() {
            return this.key;
        }

        public V1 getCurrentValue() {
            return this.value;
        }
    }
}

