/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump;

import com.marklogic.contentpump.DelimitedJSONReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ZipDelimitedJSONReader
extends DelimitedJSONReader<Text> {
    public static final Log LOG = LogFactory.getLog(ZipDelimitedJSONReader.class);
    private byte[] buf = new byte[65536];
    private InputStream zipIn;
    private ZipEntry currZipEntry;

    @Override
    public void close() throws IOException {
        super.close();
        if (this.zipIn != null) {
            this.zipIn.close();
        }
    }

    @Override
    protected void initFileStream(InputSplit inSplit) throws IOException, InterruptedException {
        this.fileIn = this.openFile(inSplit, false);
        if (this.fileIn == null) {
            return;
        }
        this.zipIn = new ZipInputStream((InputStream)this.fileIn);
    }

    @Override
    public void initialize(InputSplit inSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        super.initialize(inSplit, context);
        this.findNextFileEntryAndInitReader();
    }

    @Override
    protected boolean findNextFileEntryAndInitReader() throws InterruptedException, IOException {
        while (true) {
            if (this.hasMoreEntryInZip()) {
                return true;
            }
            if (this.iterator == null || !this.iterator.hasNext()) break;
            this.initFileStream((InputSplit)this.iterator.next());
        }
        this.hasNext = false;
        return false;
    }

    protected boolean hasMoreEntryInZip() throws IOException {
        ZipInputStream zipIStream = (ZipInputStream)this.zipIn;
        while ((this.currZipEntry = zipIStream.getNextEntry()) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ZipEntry: " + this.currZipEntry.getName()));
            }
            if (this.currZipEntry.getSize() == 0L) continue;
            this.subId = this.currZipEntry.getName();
            this.configFileNameAsCollection(this.conf, this.file);
            this.instream = new InputStreamReader((InputStream)zipIStream, this.encoding);
            this.reader = new LineNumberReader(this.instream);
            return true;
        }
        return false;
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.hasNext ? 0.0f : 1.0f;
    }

    @Override
    protected void configFileNameAsCollection(Configuration conf, Path file) {
        String collectionName = file.getName() + "_" + this.currZipEntry.getName();
        super.configFileNameAsCollection(conf, new Path(collectionName));
    }
}

