/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump.examples;

import com.marklogic.contentpump.examples.SimpleSequenceFileKey;
import com.marklogic.contentpump.examples.SimpleSequenceFileValue;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;

public class SimpleSequenceFileReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) throws Exception {
        System.out.println("Sequence File Reader");
        String uri = args[0];
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        Path path = new Path(uri);
        SequenceFile.Reader reader = null;
        try {
            reader = new SequenceFile.Reader(fs, path, conf);
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Writable value = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            long position = reader.getPosition();
            while (reader.next(key, value)) {
                String syncSeen = reader.syncSeen() ? "*" : "";
                System.out.printf("[%s%s]\t%s\t%s\n", position, syncSeen, ((SimpleSequenceFileKey)key).getDocumentURI().getUri(), ((SimpleSequenceFileValue)value).getValue());
                position = reader.getPosition();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            IOUtils.closeStream((Closeable)reader);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    IOUtils.closeStream(reader);
                    throw throwable;
                }
            }
            IOUtils.closeStream((Closeable)reader);
        }
        IOUtils.closeStream((Closeable)reader);
    }
}

