/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump.examples;

import com.marklogic.contentpump.SequenceFileValue;
import com.marklogic.mapreduce.MarkLogicNode;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class SimpleSequenceFileValue<T>
implements SequenceFileValue<T>,
Writable {
    private byte type;
    private T value;

    public void setValue(T v) {
        this.value = v;
        if (this.value instanceof Text) {
            this.type = 0;
        } else if (this.value instanceof MarkLogicNode) {
            this.type = 1;
        } else if (this.value instanceof BytesWritable) {
            this.type = (byte)2;
        }
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public void readFields(DataInput in) throws IOException {
        byte valueType = in.readByte();
        switch (valueType) {
            case 0: {
                this.value = new Text();
                ((Text)this.value).readFields(in);
                break;
            }
            case 1: {
                this.value = new MarkLogicNode();
                ((MarkLogicNode)this.value).readFields(in);
                break;
            }
            case 2: {
                this.value = new BytesWritable();
                ((BytesWritable)this.value).readFields(in);
                break;
            }
            default: {
                throw new IOException("incorrect type");
            }
        }
        this.type = valueType;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.type);
        if (this.value instanceof Text) {
            ((Text)this.value).write(out);
        } else if (this.value instanceof MarkLogicNode) {
            ((MarkLogicNode)this.value).write(out);
        } else if (this.value instanceof BytesWritable) {
            ((BytesWritable)this.value).write(out);
        }
    }
}

