/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.contentpump.test;

import com.marklogic.contentpump.examples.SimpleSequenceFileKey;
import com.marklogic.contentpump.examples.SimpleSequenceFileValue;
import com.marklogic.mapreduce.DocumentURI;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;

public class SimpleSequenceFileLargeBinaryCreator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        System.out.println("Sequence File Creator");
        String uri = args[0];
        String binaryfile = args[1];
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        Path path = new Path(uri);
        SequenceFile.Writer writer = null;
        SimpleSequenceFileKey key = new SimpleSequenceFileKey();
        SimpleSequenceFileValue<BytesWritable> value = new SimpleSequenceFileValue<BytesWritable>();
        try {
            long size;
            BytesWritable bw = new BytesWritable();
            Path file = new Path(binaryfile);
            FileSystem fs1 = file.getFileSystem(conf);
            FSDataInputStream fileIn = fs1.open(file);
            byte[] buf = new byte[65535];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((size = (long)fileIn.read(buf, 0, buf.length)) != -1L) {
                baos.write(buf, 0, (int)size);
            }
            bw.set(baos.toByteArray(), 0, baos.size());
            writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path, key.getClass(), value.getClass());
            key.setDocumentURI(new DocumentURI("Large"));
            value.setValue(bw);
            writer.append((Writable)key, value);
            System.err.println(key.getDocumentURI().getUri() + " loaded.");
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(writer);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)writer);
    }
}

